/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.pm.config.PasswordManagementConfiguration;
import org.apereo.cas.pm.config.PasswordManagementForgotUsernameConfiguration;
import org.apereo.cas.pm.config.PasswordManagementWebflowConfiguration;
import org.apereo.cas.web.config.CasSupportActionsConfiguration;
import org.apereo.cas.web.flow.BaseWebflowConfigurerTests;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@Import(value={CasSupportActionsConfiguration.class, PasswordManagementConfiguration.class, PasswordManagementWebflowConfiguration.class, PasswordManagementForgotUsernameConfiguration.class})
@TestPropertySource(properties={"cas.authn.pm.forgot-username.google-recaptcha.enabled=true", "cas.authn.pm.core.enabled=true", "cas.authn.pm.reset.crypto.encryption.key=qLhvLuaobvfzMmbo9U_bYA", "cas.authn.pm.reset.crypto.signing.key=oZeAR5pEXsolruu4OQYsQKxf-FCvFzSsKlsVaKmfIl6pNzoPm6zPW94NRS1af7vT-0bb3DpPBeksvBXjloEsiA"})
@Tag(value="WebflowConfig")
public class ForgotUsernameCaptchaWebflowConfigurerTests
extends BaseWebflowConfigurerTests {
    @Autowired
    @Qualifier(value="forgotUsernameInitializeCaptchaAction")
    private Action initCaptchaAction;

    @Test
    public void verifyCaptcha() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        this.initCaptchaAction.execute((RequestContext)context);
        Assertions.assertTrue((boolean)WebUtils.isRecaptchaForgotUsernameEnabled((RequestContext)context));
    }

    @Test
    public void verifyOperation() {
        Flow flow = (Flow)this.loginFlowDefinitionRegistry.getFlowDefinition("login");
        Assertions.assertNotNull((Object)flow);
        TransitionableState state = (TransitionableState)flow.getState("sendForgotUsernameInstructions");
        Assertions.assertEquals((Object)"casForgotUsernameSendInfoView", (Object)state.getTransition("captchaError").getTargetStateId());
    }
}

