/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import java.util.Arrays;
import org.apereo.cas.pm.config.PasswordManagementConfiguration;
import org.apereo.cas.pm.config.PasswordManagementWebflowConfiguration;
import org.apereo.cas.web.flow.BaseWebflowConfigurerTests;
import org.apereo.cas.web.flow.config.CasWebflowAccountProfileConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.Flow;

@Import(value={PasswordManagementConfiguration.class, PasswordManagementWebflowConfiguration.class, CasWebflowAccountProfileConfiguration.class})
@Tag(value="WebflowConfig")
@TestPropertySource(properties={"cas.authn.pm.core.enabled=true", "CasFeatureModule.AccountManagement.enabled=true"})
public class PasswordManagementAccountProfileWebflowConfigurerTests
extends BaseWebflowConfigurerTests {
    @Autowired
    @Qualifier(value="accountProfileFlowRegistry")
    private FlowDefinitionRegistry accountProfileFlowRegistry;

    @Test
    public void verifyOperation() {
        Flow flow = (Flow)this.accountProfileFlowRegistry.getFlowDefinition("account");
        Assertions.assertNotNull((Object)flow);
        Assertions.assertTrue((boolean)Arrays.stream(flow.getStartActionList().toArray()).anyMatch(ac -> ac.toString().contains("prepareAccountProfilePasswordMgmtAction")));
    }
}

