/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.web.flow.config.CasWebflowAccountProfileConfiguration;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="WebflowActions")
@TestPropertySource(properties={"CasFeatureModule.AccountManagement.enabled=true"})
@Import(value={CasWebflowAccountProfileConfiguration.class})
public class AccountProfilePasswordChangeRequestActionTests
extends BasePasswordManagementActionTests {
    @Autowired
    @Qualifier(value="accountProfilePasswordChangeRequestAction")
    private Action accountProfilePasswordChangeRequestAction;

    @Test
    public void verifyOperation() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (TicketGrantingTicket)tgt);
        WebUtils.putTicketGrantingTicket((RequestContext)context, (TicketGrantingTicket)tgt);
        this.ticketRegistry.addTicket((Ticket)tgt);
        Event result = this.accountProfilePasswordChangeRequestAction.execute((RequestContext)context);
        Assertions.assertEquals((Object)"success", (Object)result.getId());
        Assertions.assertNotNull((Object)WebUtils.getServiceRedirectUrl((RequestContext)context));
        Assertions.assertThrows(InvalidTicketException.class, () -> this.ticketRegistry.getTicket(tgt.getId(), TicketGrantingTicket.class));
    }
}

