/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.web.flow.config.CasWebflowAccountProfileConfiguration;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.message.MessageContext;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockFlowExecutionContext;
import org.springframework.webflow.test.MockFlowSession;
import org.springframework.webflow.test.MockParameterMap;

@Tag(value="WebflowActions")
@TestPropertySource(properties={"cas.authn.pm.groovy.location=classpath:PasswordManagementService.groovy", "cas.authn.pm.core.enabled=true", "cas.authn.pm.reset.security-questions-enabled=true", "CasFeatureModule.AccountManagement.enabled=true"})
@Import(value={CasWebflowAccountProfileConfiguration.class})
public class AccountProfileUpdateSecurityQuestionsActionTests
extends BasePasswordManagementActionTests {
    @Autowired
    @Qualifier(value="accountProfileUpdateSecurityQuestionsAction")
    private Action accountProfileUpdateSecurityQuestionsAction;
    private MockParameterMap parameterMap;
    private RequestContext context;

    private static RequestContext getRequestContext(MockParameterMap parameterMap) {
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        RequestContext context = (RequestContext)Mockito.mock(RequestContext.class);
        Mockito.when((Object)context.getFlashScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getFlowScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getRequestScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getMessageContext()).thenReturn((Object)((MessageContext)Mockito.mock(MessageContext.class)));
        Mockito.when((Object)context.getRequestParameters()).thenReturn((Object)parameterMap);
        Mockito.when((Object)context.getExternalContext()).thenReturn((Object)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        Mockito.when((Object)context.getFlowExecutionContext()).thenReturn((Object)new MockFlowExecutionContext((FlowSession)new MockFlowSession(new Flow("mockFlow"))));
        return context;
    }

    @BeforeEach
    public void setup() throws Exception {
        this.parameterMap = new MockParameterMap();
        this.context = AccountProfileUpdateSecurityQuestionsActionTests.getRequestContext(this.parameterMap);
        RequestContextHolder.setRequestContext((RequestContext)this.context);
        ExternalContextHolder.setExternalContext((ExternalContext)this.context.getExternalContext());
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        WebUtils.putTicketGrantingTicketInScopes((RequestContext)this.context, (TicketGrantingTicket)tgt);
        WebUtils.putTicketGrantingTicket((RequestContext)this.context, (TicketGrantingTicket)tgt);
        this.ticketRegistry.addTicket((Ticket)tgt);
    }

    @Test
    public void verifyMismatchedQuestionsAndAnswers() throws Exception {
        this.parameterMap.put("questions", new String[]{"question1", "question2", "question3"});
        this.parameterMap.put("answers", new String[]{"answer1", "answer2"});
        Event result = this.accountProfileUpdateSecurityQuestionsAction.execute(this.context);
        Assertions.assertEquals((Object)"error", (Object)result.getId());
    }

    @Test
    public void verifyShortQuestions() throws Exception {
        this.parameterMap.put("questions", new String[]{"qaz", "zsxa", "123"});
        this.parameterMap.put("answers", new String[]{"a", "b", "c"});
        Event result = this.accountProfileUpdateSecurityQuestionsAction.execute(this.context);
        Assertions.assertEquals((Object)"error", (Object)result.getId());
    }

    @Test
    public void verifyOperationPasses() throws Exception {
        this.parameterMap.put("questions", new String[]{"question1", "question2"});
        this.parameterMap.put("answers", new String[]{"answer1", "answer2"});
        Event result = this.accountProfileUpdateSecurityQuestionsAction.execute(this.context);
        Assertions.assertEquals((Object)"success", (Object)result.getId());
    }
}

