/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.message.MessageContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockParameterMap;

@Tag(value="WebflowActions")
public class AccountUnlockStatusActionTests
extends BasePasswordManagementActionTests {
    @Autowired
    @Qualifier(value="accountUnlockStatusAction")
    protected Action action;

    @Test
    public void verifyBadCaptcha() throws Exception {
        RequestContext context = AccountUnlockStatusActionTests.getRequestContext("good", "bad");
        Event result = this.action.execute(context);
        Assertions.assertEquals((Object)"error", (Object)result.getId());
    }

    @Test
    public void verifyAccountUnlock() throws Exception {
        RequestContext context = AccountUnlockStatusActionTests.getRequestContext("good", "good");
        Event result = this.action.execute(context);
        Assertions.assertEquals((Object)"success", (Object)result.getId());
    }

    private static RequestContext getRequestContext(String captcha, String givenCaptcha) {
        RequestContext context = (RequestContext)Mockito.mock(RequestContext.class);
        Mockito.when((Object)context.getMessageContext()).thenReturn((Object)((MessageContext)Mockito.mock(MessageContext.class)));
        Mockito.when((Object)context.getFlowScope()).thenReturn((Object)new LocalAttributeMap());
        MockParameterMap requestParameters = new MockParameterMap();
        requestParameters.put("captchaValue", givenCaptcha);
        Mockito.when((Object)context.getRequestParameters()).thenReturn((Object)requestParameters);
        LocalAttributeMap conversation = new LocalAttributeMap();
        UsernamePasswordCredential credential = RegisteredServiceTestUtils.getCredentialsWithSameUsernameAndPassword((String)"casuser");
        conversation.put(Credential.class.getName(), (Object)credential);
        conversation.put("captchaValue", (Object)captcha);
        Mockito.when((Object)context.getConversationScope()).thenReturn((Object)conversation);
        Mockito.when((Object)context.getExternalContext()).thenReturn((Object)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse()));
        return context;
    }
}

