/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.message.MessageContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockParameterMap;

@EnabledIfListeningOnPort(port={25000})
public class SendForgotUsernameInstructionsActionTests {

    @Tag(value="Mail")
    @Nested
    @TestPropertySource(properties={"spring.boot.config.CasPersonDirectoryTestConfiguration.enabled=false"})
    public class NoPrincipalResolutionTests
    extends BasePasswordManagementActionTests {
        @Autowired
        @Qualifier(value="sendForgotUsernameInstructionsAction")
        protected Action sendForgotUsernameInstructionsAction;

        @Test
        public void verifyOpWithoutPrincipalResolution() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            LocalAttributeMap flashScope = new LocalAttributeMap();
            RequestContext context = (RequestContext)Mockito.mock(RequestContext.class);
            Mockito.when((Object)context.getMessageContext()).thenReturn((Object)((MessageContext)Mockito.mock(MessageContext.class)));
            Mockito.when((Object)context.getFlowScope()).thenReturn((Object)new LocalAttributeMap());
            Mockito.when((Object)context.getFlashScope()).thenReturn((Object)flashScope);
            Mockito.when((Object)context.getRequestScope()).thenReturn((Object)new LocalAttributeMap());
            Mockito.when((Object)context.getConversationScope()).thenReturn((Object)new LocalAttributeMap());
            Mockito.when((Object)context.getRequestParameters()).thenReturn((Object)new MockParameterMap());
            Mockito.when((Object)context.getExternalContext()).thenReturn((Object)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
            request.setParameter("email", "casuser@apereo.org");
            Event result = this.sendForgotUsernameInstructionsAction.execute(context);
            Assertions.assertEquals((Object)"success", (Object)result.getId());
            Assertions.assertFalse((boolean)flashScope.contains(Principal.class.getName()));
        }
    }

    @Tag(value="Mail")
    @Nested
    public class DefaultTests
    extends BasePasswordManagementActionTests {
        @Autowired
        @Qualifier(value="sendForgotUsernameInstructionsAction")
        protected Action sendForgotUsernameInstructionsAction;

        @Test
        public void verifyNoEmailOrUser() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            RequestContext context = (RequestContext)Mockito.mock(RequestContext.class);
            Mockito.when((Object)context.getMessageContext()).thenReturn((Object)((MessageContext)Mockito.mock(MessageContext.class)));
            LocalAttributeMap flashScope = new LocalAttributeMap();
            Mockito.when((Object)context.getFlashScope()).thenReturn((Object)flashScope);
            Mockito.when((Object)context.getFlowScope()).thenReturn((Object)new LocalAttributeMap());
            Mockito.when((Object)context.getRequestScope()).thenReturn((Object)new LocalAttributeMap());
            Mockito.when((Object)context.getConversationScope()).thenReturn((Object)new LocalAttributeMap());
            Mockito.when((Object)context.getRequestParameters()).thenReturn((Object)new MockParameterMap());
            Mockito.when((Object)context.getExternalContext()).thenReturn((Object)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
            Event result = this.sendForgotUsernameInstructionsAction.execute(context);
            Assertions.assertEquals((Object)"error", (Object)result.getId());
            request.addParameter("email", "123456");
            result = this.sendForgotUsernameInstructionsAction.execute(context);
            Assertions.assertEquals((Object)"error", (Object)result.getId());
            request.setParameter("email", "casuser@baddomain.org");
            result = this.sendForgotUsernameInstructionsAction.execute(context);
            Assertions.assertEquals((Object)"error", (Object)result.getId());
            Assertions.assertFalse((boolean)flashScope.contains(Principal.class.getName()));
        }

        @Test
        public void verifyOp() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            MockHttpServletResponse response = new MockHttpServletResponse();
            LocalAttributeMap flashScope = new LocalAttributeMap();
            RequestContext context = (RequestContext)Mockito.mock(RequestContext.class);
            Mockito.when((Object)context.getMessageContext()).thenReturn((Object)((MessageContext)Mockito.mock(MessageContext.class)));
            Mockito.when((Object)context.getFlowScope()).thenReturn((Object)new LocalAttributeMap());
            Mockito.when((Object)context.getRequestScope()).thenReturn((Object)new LocalAttributeMap());
            Mockito.when((Object)context.getConversationScope()).thenReturn((Object)new LocalAttributeMap());
            Mockito.when((Object)context.getFlashScope()).thenReturn((Object)flashScope);
            Mockito.when((Object)context.getRequestParameters()).thenReturn((Object)new MockParameterMap());
            Mockito.when((Object)context.getExternalContext()).thenReturn((Object)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
            request.setParameter("email", "casuser@apereo.org");
            Event result = this.sendForgotUsernameInstructionsAction.execute(context);
            Assertions.assertEquals((Object)"success", (Object)result.getId());
            Assertions.assertTrue((boolean)flashScope.contains(Principal.class.getName()));
        }
    }
}

