/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.pm.web.flow.actions.BasePasswordManagementActionTests;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@EnabledIfListeningOnPort(port={25000})
@Tag(value="Mail")
public class ValidatePasswordResetTokenActionTests
extends BasePasswordManagementActionTests {
    @Test
    public void verifyInvalidTicket() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        request.addParameter("pswdrst", UUID.randomUUID().toString());
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assertions.assertEquals((Object)"invalidPasswordResetToken", (Object)this.validatePasswordResetTokenAction.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyNoParam() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assertions.assertNull((Object)this.validatePasswordResetTokenAction.execute((RequestContext)context));
    }

    @Test
    public void verifyInvalidToken() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        String ticketId = UUID.randomUUID().toString();
        TransientSessionTicket sts = (TransientSessionTicket)Mockito.mock(TransientSessionTicket.class);
        Mockito.when((Object)sts.getProperties()).thenReturn(Map.of("token", "invalid"));
        Mockito.when((Object)sts.getId()).thenReturn((Object)ticketId);
        this.ticketRegistry.addTicket((Ticket)sts);
        request.addParameter("pswdrst", ticketId);
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assertions.assertEquals((Object)"invalidPasswordResetToken", (Object)this.validatePasswordResetTokenAction.execute((RequestContext)context).getId());
    }
}

