/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.BasePasswordManagementService;
import org.apereo.cas.pm.PasswordChangeBean;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class JsonResourcePasswordManagementService
extends BasePasswordManagementService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonResourcePasswordManagementService.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();
    private final Resource jsonResource;
    private Map<String, JsonBackedAccount> jsonBackedAccounts;

    public JsonResourcePasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, String issuer, PasswordManagementProperties passwordManagementProperties, Resource jsonResource) {
        super(cipherExecutor, issuer, passwordManagementProperties);
        this.jsonResource = jsonResource;
        this.readAccountsFromJsonResource();
    }

    private void readAccountsFromJsonResource() {
        try (InputStreamReader reader = new InputStreamReader(this.jsonResource.getInputStream(), StandardCharsets.UTF_8);){
            TypeReference<Map<String, JsonBackedAccount>> personList = new TypeReference<Map<String, JsonBackedAccount>>(){};
            this.jsonBackedAccounts = (Map)MAPPER.readValue(JsonValue.readHjson((Reader)reader).toString(), (TypeReference)personList);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public boolean changeInternal(Credential credential, PasswordChangeBean bean) {
        Assert.notNull((Object)credential, (String)"Credential cannot be null");
        Assert.notNull((Object)bean, (String)"PasswordChangeBean cannot be null");
        UsernamePasswordCredential c = (UsernamePasswordCredential)credential;
        if (StringUtils.isBlank((CharSequence)c.getPassword()) || StringUtils.isBlank((CharSequence)bean.getPassword())) {
            LOGGER.error("Password cannot be blank");
            return false;
        }
        if (!StringUtils.equals((CharSequence)bean.getPassword(), (CharSequence)bean.getConfirmedPassword())) {
            LOGGER.error("Password does not match and cannot be confirmed");
            return false;
        }
        JsonBackedAccount account = this.jsonBackedAccounts.getOrDefault(c.getId(), null);
        if (account == null) {
            LOGGER.error("User account [{}] cannot be found", (Object)c.getId());
            return false;
        }
        account.setPassword(bean.getPassword());
        this.jsonBackedAccounts.put(c.getId(), account);
        return this.writeAccountToJsonResource();
    }

    private boolean writeAccountToJsonResource() {
        try {
            MAPPER.writerWithDefaultPrettyPrinter().writeValue(this.jsonResource.getFile(), this.jsonBackedAccounts);
            this.readAccountsFromJsonResource();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return true;
    }

    @Override
    public String findEmail(String username) {
        JsonBackedAccount account = this.jsonBackedAccounts.getOrDefault(username, null);
        return account == null ? null : account.getEmail();
    }

    @Override
    public Map<String, String> getSecurityQuestions(String username) {
        JsonBackedAccount account = this.jsonBackedAccounts.getOrDefault(username, null);
        if (account != null) {
            return account.getSecurityQuestions();
        }
        return new HashMap<String, String>();
    }

    private static class JsonBackedAccount {
        private String email;
        private String password;
        private Map<String, String> securityQuestions = new HashMap<String, String>();

        JsonBackedAccount() {
        }

        JsonBackedAccount(String email, String password, Map<String, String> securityQuestions) {
            this.email = email;
            this.password = password;
            this.securityQuestions = securityQuestions;
        }

        public Map<String, String> getSecurityQuestions() {
            return this.securityQuestions;
        }

        public void setSecurityQuestions(Map<String, String> securityQuestions) {
            this.securityQuestions = securityQuestions;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

