/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm;

import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.pm.config.PasswordManagementConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={RefreshAutoConfiguration.class, PasswordManagementConfiguration.class, MailSenderAutoConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreUtilConfiguration.class}, properties={"cas.authn.pm.core.enabled=true", "cas.authn.pm.history.core.enabled=true", "cas.authn.pm.core.policy-pattern=^Th!.+{8,10}"})
@Tag(value="PasswordOps")
public class DefaultPasswordValidationServiceTests {
    @Autowired
    @Qualifier(value="passwordValidationService")
    private PasswordValidationService passwordValidationService;
    @Autowired
    @Qualifier(value="passwordHistoryService")
    private PasswordHistoryService passwordHistoryService;

    @Test
    public void verifyReuseOldPassword() {
        UsernamePasswordCredential creds = CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"casuser", (String)"This!$P@$$");
        Assertions.assertFalse((boolean)this.passwordValidationService.isValid(creds, new PasswordChangeRequest("user", "123456", "123456")));
        Assertions.assertFalse((boolean)this.passwordValidationService.isValid(creds, new PasswordChangeRequest("user", "This!$P@$$", "This!$P@$$")));
    }

    @Test
    public void verifyValidity() {
        UsernamePasswordCredential creds = CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"casuser", (String)"password");
        Assertions.assertFalse((boolean)this.passwordValidationService.isValid(creds, new PasswordChangeRequest("user", "", null)));
        Assertions.assertFalse((boolean)this.passwordValidationService.isValid(creds, new PasswordChangeRequest("user", "password", "password")));
        Assertions.assertFalse((boolean)this.passwordValidationService.isValid(creds, new PasswordChangeRequest("user", "Th!sIsT3st", "password")));
        PasswordChangeRequest request = new PasswordChangeRequest("user", "Th!sIsT3st", "Th!sIsT3st");
        Assertions.assertTrue((boolean)this.passwordValidationService.isValid(creds, request));
        this.passwordHistoryService.store(request);
        Assertions.assertFalse((boolean)this.passwordValidationService.isValid(creds, request));
    }
}

