/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.history;

import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.config.PasswordManagementConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={RefreshAutoConfiguration.class, PasswordManagementConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreUtilConfiguration.class}, properties={"cas.authn.pm.core.enabled=true", "cas.authn.pm.history.core.enabled=true"})
@Tag(value="PasswordOps")
public class InMemoryPasswordHistoryServiceTests {
    @Autowired
    @Qualifier(value="passwordHistoryService")
    private PasswordHistoryService passwordHistoryService;

    @Test
    public void verifyValidity() {
        this.passwordHistoryService.removeAll();
        Assertions.assertTrue((boolean)this.passwordHistoryService.fetchAll().isEmpty());
        PasswordChangeRequest request = new PasswordChangeRequest("casuser", "password", "password");
        Assertions.assertFalse((boolean)this.passwordHistoryService.exists(request));
        Assertions.assertTrue((boolean)this.passwordHistoryService.store(request));
        Assertions.assertTrue((boolean)this.passwordHistoryService.exists(request));
        Assertions.assertFalse((boolean)this.passwordHistoryService.fetchAll().isEmpty());
        Assertions.assertFalse((boolean)this.passwordHistoryService.fetch("casuser").isEmpty());
        this.passwordHistoryService.remove("casuser");
        Assertions.assertTrue((boolean)this.passwordHistoryService.fetch("casuser").isEmpty());
    }
}

