/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.impl;

import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.config.PasswordManagementConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={RefreshAutoConfiguration.class, PasswordManagementConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreUtilConfiguration.class}, properties={"cas.authn.pm.core.enabled=true", "cas.authn.pm.groovy.location=classpath:/GroovyPasswordMgmt.groovy"})
@Tag(value="Groovy")
public class GroovyResourcePasswordManagementServiceTests {
    @Autowired
    @Qualifier(value="passwordChangeService")
    private PasswordManagementService passwordChangeService;

    @Test
    public void verifyFindEmail() {
        Assertions.assertNotNull((Object)this.passwordChangeService.findEmail(PasswordManagementQuery.builder().username("casuser").build()));
    }

    @Test
    public void verifyFindUser() {
        Assertions.assertNotNull((Object)this.passwordChangeService.findUsername(PasswordManagementQuery.builder().username("casuser@example.org").build()));
    }

    @Test
    public void verifyChangePassword() {
        Assertions.assertTrue((boolean)this.passwordChangeService.change((Credential)CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"casuser", (String)"password"), new PasswordChangeRequest("casuser", "password", "password")));
    }

    @Test
    public void verifySecurityQuestions() {
        final PasswordManagementQuery query = PasswordManagementQuery.builder().username("casuser@example.org").build();
        Assertions.assertFalse((boolean)this.passwordChangeService.getSecurityQuestions(query).isEmpty());
        query.securityQuestion("Q1", "A1");
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() throws Throwable {
                GroovyResourcePasswordManagementServiceTests.this.passwordChangeService.updateSecurityQuestions(query);
            }
        });
    }
}

