/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.impl;

import java.util.Map;
import java.util.UUID;
import org.apereo.cas.audit.spi.config.CasCoreAuditConfiguration;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.pm.config.PasswordManagementConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={RefreshAutoConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreHttpConfiguration.class, CasCoreAuditConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreTicketsConfiguration.class, CasPersonDirectoryConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreServicesAuthenticationConfiguration.class, CasCoreServicesConfiguration.class, CasCoreWebConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreConfiguration.class, CasCoreUtilConfiguration.class, MailSenderAutoConfiguration.class, PasswordManagementConfiguration.class}, properties={"cas.authn.pm.json.location=classpath:jsonResourcePassword.json", "cas.authn.pm.core.enabled=true", "cas.authn.pm.core.policy-pattern=^Test1.+"})
@Tag(value="FileSystem")
public class JsonResourcePasswordManagementServiceTests {
    @Autowired
    @Qualifier(value="passwordChangeService")
    private PasswordManagementService passwordChangeService;
    @Autowired
    @Qualifier(value="passwordValidationService")
    private PasswordValidationService passwordValidationService;

    @Test
    public void verifyUserEmailCanBeFound() {
        String email = this.passwordChangeService.findEmail(PasswordManagementQuery.builder().username("casuser").build());
        Assertions.assertEquals((Object)"casuser@example.org", (Object)email);
    }

    @Test
    public void verifyUserCanBeFound() {
        String user = this.passwordChangeService.findUsername(PasswordManagementQuery.builder().email("casuser@example.org").build());
        Assertions.assertEquals((Object)"casuser", (Object)user);
    }

    @Test
    public void verifyUserPhoneCanBeFound() {
        String phone = this.passwordChangeService.findPhone(PasswordManagementQuery.builder().username("casuser").build());
        Assertions.assertEquals((Object)"1234567890", (Object)phone);
    }

    @Test
    public void verifyUserEmailCanNotBeFound() {
        String email = this.passwordChangeService.findEmail(PasswordManagementQuery.builder().username("casusernotfound").build());
        Assertions.assertNull((Object)email);
    }

    @Test
    public void verifyUserQuestionsCanBeFound() {
        Map questions = this.passwordChangeService.getSecurityQuestions(PasswordManagementQuery.builder().username("casuser").build());
        Assertions.assertEquals((int)2, (int)questions.size());
        Assertions.assertTrue((boolean)this.passwordChangeService.getSecurityQuestions(PasswordManagementQuery.builder().username(UUID.randomUUID().toString()).build()).isEmpty());
    }

    @Test
    public void verifyUserPasswordChange() {
        UsernamePasswordCredential c = new UsernamePasswordCredential("casuser", "password");
        PasswordChangeRequest bean = new PasswordChangeRequest();
        bean.setConfirmedPassword("newPassword");
        bean.setPassword("newPassword");
        boolean res = this.passwordChangeService.change((Credential)c, bean);
        Assertions.assertTrue((boolean)res);
    }

    @Test
    public void verifyUserPasswordChangeFail() {
        UsernamePasswordCredential c = new UsernamePasswordCredential("casuser", "password");
        PasswordChangeRequest bean = new PasswordChangeRequest();
        bean.setConfirmedPassword("newPassword");
        boolean res = this.passwordChangeService.change((Credential)c, bean);
        Assertions.assertFalse((boolean)res);
        bean.setConfirmedPassword("newPassword");
        bean.setPassword("unknown");
        res = this.passwordChangeService.change((Credential)c, bean);
        Assertions.assertFalse((boolean)res);
        bean.setPassword(bean.getConfirmedPassword());
        c.setUsername(UUID.randomUUID().toString());
        res = this.passwordChangeService.change((Credential)c, bean);
        Assertions.assertFalse((boolean)res);
    }

    @Test
    public void verifyPasswordValidationService() {
        UsernamePasswordCredential c = new UsernamePasswordCredential("casuser", "password");
        PasswordChangeRequest bean = new PasswordChangeRequest();
        bean.setUsername(c.getUsername());
        bean.setConfirmedPassword("Test1@1234");
        bean.setPassword("Test1@1234");
        boolean isValid = this.passwordValidationService.isValid(c, bean);
        Assertions.assertTrue((boolean)isValid);
    }

    @Test
    public void verifySecurityQuestions() {
        final PasswordManagementQuery query = PasswordManagementQuery.builder().username("casuser").build();
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() throws Throwable {
                query.securityQuestion("Q1", "A1");
                query.securityQuestion("Q2", "A2");
                JsonResourcePasswordManagementServiceTests.this.passwordChangeService.updateSecurityQuestions(query);
            }
        });
        Assertions.assertFalse((boolean)this.passwordChangeService.getSecurityQuestions(query).isEmpty());
    }
}

