/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.impl;

import java.time.Clock;
import java.time.Instant;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.impl.NoOpPasswordManagementService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.mock.web.MockHttpServletRequest;

@Tag(value="PasswordOps")
public class NoOpPasswordManagementServiceTests {
    @Test
    public void verifyChange() {
        PasswordManagementProperties properties = new PasswordManagementProperties();
        NoOpPasswordManagementService service = new NoOpPasswordManagementService(CipherExecutor.noOpOfSerializableToString(), "CAS", properties);
        Assertions.assertFalse((boolean)service.changeInternal((Credential)RegisteredServiceTestUtils.getCredentialsWithSameUsernameAndPassword((String)"casuser"), new PasswordChangeRequest()));
    }

    @Test
    public void verifyTokenParsing() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRemoteAddr("185.86.151.11");
        request.setLocalAddr("185.88.151.11");
        ClientInfo clientInfo = new ClientInfo((HttpServletRequest)request);
        ClientInfoHolder.setClientInfo((ClientInfo)clientInfo);
        PasswordManagementProperties properties = new PasswordManagementProperties();
        NoOpPasswordManagementService service = new NoOpPasswordManagementService(CipherExecutor.noOpOfSerializableToString(), "CAS", properties);
        String token = UUID.randomUUID().toString();
        JwtClaims claims = new JwtClaims();
        claims.setJwtId(token);
        claims.setIssuer("bad-issuer");
        Assertions.assertNull((Object)service.parseToken(claims.toJson()));
        claims.setIssuer("CAS");
        claims.setAudience("other-audience");
        Assertions.assertNull((Object)service.parseToken(claims.toJson()));
        claims.setAudience("CAS");
        claims.setSubject("");
        Assertions.assertNull((Object)service.parseToken(claims.toJson()));
        claims.setClaim("origin", (Object)"whatever");
        claims.setSubject("casuser");
        Assertions.assertNull((Object)service.parseToken(claims.toJson()));
        claims.setClaim("origin", (Object)clientInfo.getServerIpAddress());
        claims.setClaim("client", (Object)"whatever");
        Assertions.assertNull((Object)service.parseToken(claims.toJson()));
        claims.setClaim("client", (Object)clientInfo.getClientIpAddress());
        long milli = Instant.now(Clock.systemUTC()).minusSeconds(500L).toEpochMilli();
        claims.setExpirationTime(NumericDate.fromMilliseconds((long)milli));
        Assertions.assertNull((Object)service.parseToken(claims.toJson()));
        claims.setExpirationTime(NumericDate.now());
        Assertions.assertNotNull((Object)service.parseToken(claims.toJson()));
    }
}

