/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.radius.authentication;

import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import net.jradius.exception.TimeoutException;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.adaptors.radius.RadiusUtils;
import org.apereo.cas.adaptors.radius.authentication.RadiusTokenCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.util.Pair;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class RadiusTokenAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private List<RadiusServer> servers;
    private boolean failoverOnException;
    private boolean failoverOnAuthenticationFailure;

    public RadiusTokenAuthenticationHandler() {
        this.logger.debug("Using {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    public boolean supports(Credential credential) {
        return RadiusTokenCredential.class.isAssignableFrom(credential.getClass());
    }

    protected HandlerResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        try {
            RadiusTokenCredential radiusCredential = (RadiusTokenCredential)credential;
            String password = radiusCredential.getToken();
            RequestContext context = RequestContextHolder.getRequestContext();
            String username = WebUtils.getAuthentication((RequestContext)context).getPrincipal().getId();
            Pair result = RadiusUtils.authenticate((String)username, (String)password, this.servers, (boolean)this.failoverOnAuthenticationFailure, (boolean)this.failoverOnException);
            if (((Boolean)result.getFirst()).booleanValue()) {
                return this.createHandlerResult(credential, this.principalFactory.createPrincipal(username, (Map)((Optional)result.getSecond()).get()), new ArrayList());
            }
            throw new FailedLoginException("Radius authentication failed for user " + username);
        }
        catch (Exception e) {
            throw new FailedLoginException("Radius authentication failed " + e.getMessage());
        }
    }

    public boolean canPing() {
        String uidPsw = ((Object)((Object)this)).getClass().getSimpleName();
        for (RadiusServer server : this.servers) {
            this.logger.debug("Attempting to ping RADIUS server {} via simulating an authentication request. If the server responds successfully, mock authentication will fail correctly.", (Object)server);
            try {
                server.authenticate(uidPsw, uidPsw);
            }
            catch (SocketTimeoutException | TimeoutException e) {
                this.logger.debug("Server {} is not available", (Object)server);
                continue;
            }
            catch (Exception e) {
                this.logger.debug("Pinging RADIUS server was successful. Response {}", (Object)e.getMessage());
            }
            return true;
        }
        return false;
    }

    public List<RadiusServer> getServers() {
        return this.servers;
    }

    public void setServers(List<RadiusServer> servers) {
        this.servers = servers;
    }

    public boolean isFailoverOnException() {
        return this.failoverOnException;
    }

    public void setFailoverOnException(boolean failoverOnException) {
        this.failoverOnException = failoverOnException;
    }

    public boolean isFailoverOnAuthenticationFailure() {
        return this.failoverOnAuthenticationFailure;
    }

    public void setFailoverOnAuthenticationFailure(boolean failoverOnAuthenticationFailure) {
        this.failoverOnAuthenticationFailure = failoverOnAuthenticationFailure;
    }
}

