/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.adaptors.radius.JRadiusServerImpl;
import org.apereo.cas.adaptors.radius.RadiusAuthenticationMetaDataPopulator;
import org.apereo.cas.adaptors.radius.RadiusClientFactory;
import org.apereo.cas.adaptors.radius.RadiusProtocol;
import org.apereo.cas.adaptors.radius.authentication.RadiusMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.radius.authentication.RadiusTokenAuthenticationHandler;
import org.apereo.cas.adaptors.radius.web.flow.RadiusAuthenticationWebflowAction;
import org.apereo.cas.adaptors.radius.web.flow.RadiusAuthenticationWebflowEventResolver;
import org.apereo.cas.adaptors.radius.web.flow.RadiusMultifactorTrustWebflowConfigurer;
import org.apereo.cas.adaptors.radius.web.flow.RadiusMultifactorWebflowConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.authentication.FirstMultifactorAuthenticationProviderSelector;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="radiusMfaConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RadiusMultifactorConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="authenticationHandlersResolvers")
    private Map authenticationHandlersResolvers;
    @Autowired
    @Qualifier(value="authenticationMetadataPopulators")
    private List authenticationMetadataPopulators;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    private FlowBuilderServices flowBuilderServices;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired(required=false)
    @Qualifier(value="multifactorAuthenticationProviderSelector")
    private MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector = new FirstMultifactorAuthenticationProviderSelector();
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private CookieGenerator warnCookieGenerator;

    @Bean
    public FlowDefinitionRegistry radiusFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder(this.applicationContext, this.flowBuilderServices);
        builder.setBasePath("classpath*:/webflow");
        builder.addFlowLocationPattern("/mfa-radius/*-webflow.xml");
        return builder.build();
    }

    @RefreshScope
    @Bean
    public List radiusTokenServers() {
        ArrayList<JRadiusServerImpl> list = new ArrayList<JRadiusServerImpl>();
        RadiusClientFactory factory = new RadiusClientFactory();
        factory.setAccountingPort(this.casProperties.getAuthn().getMfa().getRadius().getClient().getAccountingPort());
        factory.setAuthenticationPort(this.casProperties.getAuthn().getMfa().getRadius().getClient().getAuthenticationPort());
        factory.setInetAddress(this.casProperties.getAuthn().getMfa().getRadius().getClient().getInetAddress());
        factory.setSharedSecret(this.casProperties.getAuthn().getMfa().getRadius().getClient().getSharedSecret());
        factory.setSocketTimeout(this.casProperties.getAuthn().getMfa().getRadius().getClient().getSocketTimeout());
        RadiusProtocol protocol = RadiusProtocol.valueOf((String)this.casProperties.getAuthn().getMfa().getRadius().getServer().getProtocol());
        JRadiusServerImpl impl = new JRadiusServerImpl(protocol, factory);
        impl.setRetries(this.casProperties.getAuthn().getMfa().getRadius().getServer().getRetries());
        impl.setNasIdentifier(this.casProperties.getAuthn().getMfa().getRadius().getServer().getNasIdentifier());
        impl.setNasPort(this.casProperties.getAuthn().getMfa().getRadius().getServer().getNasPort());
        impl.setNasPortId(this.casProperties.getAuthn().getMfa().getRadius().getServer().getNasPortId());
        impl.setNasRealPort(this.casProperties.getAuthn().getMfa().getRadius().getServer().getNasRealPort());
        impl.setNasIpAddress(this.casProperties.getAuthn().getMfa().getRadius().getServer().getNasIpAddress());
        impl.setNasIpv6Address(this.casProperties.getAuthn().getMfa().getRadius().getServer().getNasIpv6Address());
        list.add(impl);
        return list;
    }

    @RefreshScope
    @Bean
    public MultifactorAuthenticationProvider radiusAuthenticationProvider() {
        RadiusMultifactorAuthenticationProvider p = new RadiusMultifactorAuthenticationProvider();
        p.setRadiusAuthenticationHandler(this.radiusTokenAuthenticationHandler());
        return p;
    }

    @Bean
    @RefreshScope
    public RadiusAuthenticationMetaDataPopulator radiusAuthenticationMetaDataPopulator() {
        RadiusAuthenticationMetaDataPopulator pop = new RadiusAuthenticationMetaDataPopulator();
        pop.setAuthenticationContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        pop.setAuthenticationHandler((AuthenticationHandler)this.radiusTokenAuthenticationHandler());
        pop.setProvider(this.radiusAuthenticationProvider());
        return pop;
    }

    @RefreshScope
    @Bean
    public RadiusTokenAuthenticationHandler radiusTokenAuthenticationHandler() {
        RadiusTokenAuthenticationHandler a = new RadiusTokenAuthenticationHandler();
        a.setPrincipalFactory(this.radiusTokenPrincipalFactory());
        a.setServicesManager(this.servicesManager);
        a.setServers(this.radiusTokenServers());
        a.setFailoverOnAuthenticationFailure(this.casProperties.getAuthn().getMfa().getRadius().isFailoverOnAuthenticationFailure());
        a.setFailoverOnException(this.casProperties.getAuthn().getMfa().getRadius().isFailoverOnException());
        return a;
    }

    @Bean
    public PrincipalFactory radiusTokenPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @Bean
    public Action radiusAuthenticationWebflowAction() {
        RadiusAuthenticationWebflowAction w = new RadiusAuthenticationWebflowAction();
        w.setRadiusAuthenticationWebflowEventResolver(this.radiusAuthenticationWebflowEventResolver());
        return w;
    }

    @RefreshScope
    @Bean
    public CasWebflowEventResolver radiusAuthenticationWebflowEventResolver() {
        RadiusAuthenticationWebflowEventResolver r = new RadiusAuthenticationWebflowEventResolver();
        r.setAuthenticationSystemSupport(this.authenticationSystemSupport);
        r.setCentralAuthenticationService(this.centralAuthenticationService);
        r.setMultifactorAuthenticationProviderSelector(this.multifactorAuthenticationProviderSelector);
        r.setServicesManager(this.servicesManager);
        r.setTicketRegistrySupport(this.ticketRegistrySupport);
        r.setWarnCookieGenerator(this.warnCookieGenerator);
        return r;
    }

    @ConditionalOnMissingBean(name={"radiusMultifactorWebflowConfigurer"})
    @Bean
    public CasWebflowConfigurer radiusMultifactorWebflowConfigurer() {
        RadiusMultifactorWebflowConfigurer w = new RadiusMultifactorWebflowConfigurer();
        w.setRadiusFlowRegistry(this.radiusFlowRegistry());
        w.setLoginFlowDefinitionRegistry(this.loginFlowDefinitionRegistry);
        w.setFlowBuilderServices(this.flowBuilderServices);
        return w;
    }

    @PostConstruct
    protected void initializeRootApplicationContext() {
        this.authenticationHandlersResolvers.put(this.radiusTokenAuthenticationHandler(), null);
        this.authenticationMetadataPopulators.add(0, this.radiusAuthenticationMetaDataPopulator());
    }

    @ConditionalOnClass(value={MultifactorAuthenticationTrustStorage.class})
    @ConditionalOnProperty(prefix="cas.authn.mfa.radius", name={"trustedDeviceEnabled"}, havingValue="true", matchIfMissing=true)
    @Configuration(value="radiusMultifactorTrustConfiguration")
    public class RadiusMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"radiusMultifactorTrustConfiguration"})
        @Bean
        public CasWebflowConfigurer radiusMultifactorTrustConfiguration() {
            RadiusMultifactorTrustWebflowConfigurer r = new RadiusMultifactorTrustWebflowConfigurer();
            r.setFlowDefinitionRegistry(RadiusMultifactorConfiguration.this.radiusFlowRegistry());
            r.setLoginFlowDefinitionRegistry(RadiusMultifactorConfiguration.this.loginFlowDefinitionRegistry);
            r.setFlowBuilderServices(RadiusMultifactorConfiguration.this.flowBuilderServices);
            r.setEnableDeviceRegistration(RadiusMultifactorConfiguration.this.casProperties.getAuthn().getMfa().getTrusted().isDeviceRegistrationEnabled());
            return r;
        }
    }
}

