/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.radius.authentication;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.adaptors.radius.RadiusUtils;
import org.apereo.cas.adaptors.radius.authentication.RadiusTokenCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class RadiusTokenAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RadiusTokenAuthenticationHandler.class);
    private final List<RadiusServer> servers;
    private final boolean failoverOnException;
    private final boolean failoverOnAuthenticationFailure;

    public RadiusTokenAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, List<RadiusServer> servers, boolean failoverOnException, boolean failoverOnAuthenticationFailure) {
        super(name, servicesManager, principalFactory, null);
        this.servers = servers;
        this.failoverOnException = failoverOnException;
        this.failoverOnAuthenticationFailure = failoverOnAuthenticationFailure;
        LOGGER.debug("Using [{}]", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    public boolean supports(Credential credential) {
        return RadiusTokenCredential.class.isAssignableFrom(credential.getClass());
    }

    protected HandlerResult doAuthentication(Credential credential) throws GeneralSecurityException {
        try {
            RadiusTokenCredential radiusCredential = (RadiusTokenCredential)credential;
            String password = radiusCredential.getToken();
            RequestContext context = RequestContextHolder.getRequestContext();
            String username = WebUtils.getAuthentication((RequestContext)context).getPrincipal().getId();
            Pair result = RadiusUtils.authenticate((String)username, (String)password, this.servers, (boolean)this.failoverOnAuthenticationFailure, (boolean)this.failoverOnException);
            if (((Boolean)result.getKey()).booleanValue()) {
                return this.createHandlerResult(credential, this.principalFactory.createPrincipal(username, (Map)((Optional)result.getValue()).get()), new ArrayList());
            }
            throw new FailedLoginException("Radius authentication failed for user " + username);
        }
        catch (Exception e) {
            throw new FailedLoginException("Radius authentication failed " + e.getMessage());
        }
    }
}

