/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.adaptors.radius.web.flow.RadiusAuthenticationWebflowAction;
import org.apereo.cas.adaptors.radius.web.flow.RadiusAuthenticationWebflowEventResolver;
import org.apereo.cas.adaptors.radius.web.flow.RadiusMultifactorTrustWebflowConfigurer;
import org.apereo.cas.adaptors.radius.web.flow.RadiusMultifactorWebflowConfigurer;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.authentication.RankedMultifactorAuthenticationProviderSelector;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="radiusMfaConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RadiusMultifactorConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    private FlowBuilderServices flowBuilderServices;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired(required=false)
    @Qualifier(value="multifactorAuthenticationProviderSelector")
    private MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector = new RankedMultifactorAuthenticationProviderSelector();
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private CookieGenerator warnCookieGenerator;

    @Bean
    public FlowDefinitionRegistry radiusFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder(this.applicationContext, this.flowBuilderServices);
        builder.setBasePath("classpath*:/webflow");
        builder.addFlowLocationPattern("/mfa-radius/*-webflow.xml");
        return builder.build();
    }

    @Bean
    public Action radiusAuthenticationWebflowAction() {
        return new RadiusAuthenticationWebflowAction(this.radiusAuthenticationWebflowEventResolver());
    }

    @RefreshScope
    @Bean
    public CasWebflowEventResolver radiusAuthenticationWebflowEventResolver() {
        return new RadiusAuthenticationWebflowEventResolver(this.authenticationSystemSupport, this.centralAuthenticationService, this.servicesManager, this.ticketRegistrySupport, this.warnCookieGenerator, this.authenticationRequestServiceSelectionStrategies, this.multifactorAuthenticationProviderSelector);
    }

    @ConditionalOnMissingBean(name={"radiusMultifactorWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer radiusMultifactorWebflowConfigurer() {
        RadiusMultifactorWebflowConfigurer w = new RadiusMultifactorWebflowConfigurer(this.flowBuilderServices, this.loginFlowDefinitionRegistry, this.radiusFlowRegistry(), this.applicationContext, this.casProperties);
        w.initialize();
        return w;
    }

    @ConditionalOnClass(value={MultifactorAuthenticationTrustStorage.class})
    @ConditionalOnProperty(prefix="cas.authn.mfa.radius", name={"trustedDeviceEnabled"}, havingValue="true", matchIfMissing=true)
    @Configuration(value="radiusMultifactorTrustConfiguration")
    public class RadiusMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"radiusMultifactorTrustConfiguration"})
        @Bean
        @DependsOn(value={"defaultWebflowConfigurer"})
        public CasWebflowConfigurer radiusMultifactorTrustConfiguration() {
            boolean deviceRegistrationEnabled = RadiusMultifactorConfiguration.this.casProperties.getAuthn().getMfa().getTrusted().isDeviceRegistrationEnabled();
            RadiusMultifactorTrustWebflowConfigurer w = new RadiusMultifactorTrustWebflowConfigurer(RadiusMultifactorConfiguration.this.flowBuilderServices, RadiusMultifactorConfiguration.this.loginFlowDefinitionRegistry, deviceRegistrationEnabled, RadiusMultifactorConfiguration.this.loginFlowDefinitionRegistry, RadiusMultifactorConfiguration.this.applicationContext, RadiusMultifactorConfiguration.this.casProperties);
            w.initialize();
            return w;
        }
    }
}

