/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import java.util.ArrayList;
import java.util.List;
import org.apereo.cas.adaptors.radius.JRadiusServerImpl;
import org.apereo.cas.adaptors.radius.RadiusClientFactory;
import org.apereo.cas.adaptors.radius.RadiusProtocol;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.adaptors.radius.authentication.RadiusMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.radius.authentication.RadiusTokenAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.configuration.model.support.mfa.RadiusMultifactorProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusClientProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusServerProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="radiusTokenAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RadiusTokenAuthenticationEventExecutionPlanConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @RefreshScope
    @Bean
    public MultifactorAuthenticationProvider radiusAuthenticationProvider() {
        RadiusMultifactorAuthenticationProvider p = new RadiusMultifactorAuthenticationProvider(this.radiusTokenServers());
        p.setBypassEvaluator(this.radiusBypassEvaluator());
        p.setGlobalFailureMode(this.casProperties.getAuthn().getMfa().getGlobalFailureMode());
        p.setOrder(this.casProperties.getAuthn().getMfa().getRadius().getRank());
        p.setId(this.casProperties.getAuthn().getMfa().getRadius().getId());
        return p;
    }

    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypass radiusBypassEvaluator() {
        return MultifactorAuthenticationUtils.newMultifactorAuthenticationProviderBypass((MultifactorAuthenticationProviderBypassProperties)this.casProperties.getAuthn().getMfa().getRadius().getBypass());
    }

    @RefreshScope
    @Bean
    public List<RadiusServer> radiusTokenServers() {
        ArrayList<RadiusServer> list = new ArrayList<RadiusServer>();
        RadiusClientProperties client = this.casProperties.getAuthn().getMfa().getRadius().getClient();
        RadiusServerProperties server = this.casProperties.getAuthn().getMfa().getRadius().getServer();
        RadiusClientFactory factory = new RadiusClientFactory(client.getAccountingPort(), client.getAuthenticationPort(), client.getSocketTimeout(), client.getInetAddress(), client.getSharedSecret());
        RadiusProtocol protocol = RadiusProtocol.valueOf((String)server.getProtocol());
        JRadiusServerImpl impl = new JRadiusServerImpl(protocol, factory, server.getRetries(), server.getNasIpAddress(), server.getNasIpv6Address(), server.getNasPort(), server.getNasPortId(), server.getNasIdentifier(), server.getNasRealPort());
        list.add((RadiusServer)impl);
        return list;
    }

    @ConditionalOnMissingBean(name={"radiusTokenPrincipalFactory"})
    @Bean
    public PrincipalFactory radiusTokenPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @RefreshScope
    @Bean
    public RadiusTokenAuthenticationHandler radiusTokenAuthenticationHandler() {
        RadiusMultifactorProperties radius = this.casProperties.getAuthn().getMfa().getRadius();
        return new RadiusTokenAuthenticationHandler(radius.getName(), this.servicesManager, this.radiusTokenPrincipalFactory(), this.radiusTokenServers(), radius.isFailoverOnException(), radius.isFailoverOnAuthenticationFailure());
    }

    @Bean
    @RefreshScope
    public AuthenticationMetaDataPopulator radiusAuthenticationMetaDataPopulator() {
        String attribute = this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute();
        return new AuthenticationContextAttributeMetaDataPopulator(attribute, (AuthenticationHandler)this.radiusTokenAuthenticationHandler(), this.radiusAuthenticationProvider());
    }

    @ConditionalOnMissingBean(name={"radiusTokenAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer radiusTokenAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            plan.registerAuthenticationHandler((AuthenticationHandler)this.radiusTokenAuthenticationHandler());
            plan.registerMetadataPopulator(this.radiusAuthenticationMetaDataPopulator());
        };
    }
}

