/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.radius.authentication;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import net.jradius.packet.attribute.value.AttributeValue;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.adaptors.radius.RadiusUtils;
import org.apereo.cas.adaptors.radius.authentication.RadiusTokenCredential;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadiusTokenAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RadiusTokenAuthenticationHandler.class);
    private final List<RadiusServer> servers;
    private final boolean failoverOnException;
    private final boolean failoverOnAuthenticationFailure;

    public RadiusTokenAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, List<RadiusServer> servers, boolean failoverOnException, boolean failoverOnAuthenticationFailure, Integer order) {
        super(name, servicesManager, principalFactory, order);
        this.servers = servers;
        this.failoverOnException = failoverOnException;
        this.failoverOnAuthenticationFailure = failoverOnAuthenticationFailure;
        LOGGER.debug("Using [{}]", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    public boolean supports(Credential credential) {
        return RadiusTokenCredential.class.isAssignableFrom(credential.getClass());
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return RadiusTokenCredential.class.isAssignableFrom(clazz);
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws GeneralSecurityException {
        try {
            Pair result;
            RadiusTokenCredential radiusCredential = (RadiusTokenCredential)credential;
            String password = radiusCredential.getToken();
            Authentication authentication = WebUtils.getInProgressAuthentication();
            if (authentication == null) {
                throw new IllegalArgumentException("CAS has no reference to an authentication event to locate a principal");
            }
            Principal principal = authentication.getPrincipal();
            String username = principal.getId();
            Optional<Object> state = Optional.empty();
            Map attributes = principal.getAttributes();
            if (attributes.containsKey("State")) {
                LOGGER.debug("Found state attribute in principal attributes for multifactor authentication");
                Optional stateValue = CollectionUtils.firstElement(attributes.get("State"));
                if (stateValue.isPresent()) {
                    AttributeValue stateAttr = (AttributeValue)AttributeValue.class.cast(stateValue.get());
                    state = Optional.of(stateAttr.getValueObject());
                }
            }
            if (((Boolean)(result = RadiusUtils.authenticate((String)username, (String)password, this.servers, (boolean)this.failoverOnAuthenticationFailure, (boolean)this.failoverOnException, state)).getKey()).booleanValue()) {
                Map radiusAttributes = CoreAuthenticationUtils.convertAttributeValuesToMultiValuedObjects((Map)((Map)((Optional)result.getValue()).get()));
                Principal finalPrincipal = this.principalFactory.createPrincipal(username, radiusAttributes);
                return this.createHandlerResult(credential, finalPrincipal, new ArrayList(0));
            }
            throw new FailedLoginException("Radius authentication failed for user " + username);
        }
        catch (Exception e) {
            throw new FailedLoginException("Radius authentication failed " + e.getMessage());
        }
    }
}

