/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.radius.web.flow;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apereo.cas.adaptors.radius.authentication.RadiusTokenCredential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.configurer.AbstractCasMultifactorWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class RadiusMultifactorWebflowConfigurer
extends AbstractCasMultifactorWebflowConfigurer {
    public static final String MFA_RADIUS_EVENT_ID = "mfa-radius";

    public RadiusMultifactorWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, FlowDefinitionRegistry radiusFlowRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, List<CasMultifactorWebflowCustomizer> mfaFlowCustomizers) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties, Optional.of(radiusFlowRegistry), mfaFlowCustomizers);
    }

    protected void doInitialize() {
        this.multifactorAuthenticationFlowDefinitionRegistries.forEach(registry -> {
            Flow flow = this.getFlow((FlowDefinitionRegistry)registry, MFA_RADIUS_EVENT_ID);
            this.createFlowVariable(flow, "credential", RadiusTokenCredential.class);
            flow.getStartActionList().add((Action)this.createEvaluateAction("initialFlowSetupAction"));
            ActionState initLoginFormState = this.createActionState(flow, "initializeLoginForm", (Action)this.createEvaluateAction("initializeLoginAction"));
            this.createTransitionForState((TransitionableState)initLoginFormState, "success", "viewLoginForm");
            this.setStartState(flow, (TransitionableState)initLoginFormState);
            ActionState realSubmitState = this.createActionState(flow, "realSubmit", (Action)this.createEvaluateAction("radiusAuthenticationWebflowAction"));
            this.createTransitionForState((TransitionableState)realSubmitState, "success", "success");
            this.createTransitionForState((TransitionableState)realSubmitState, "error", "initializeLoginForm");
            this.createTransitionForState((TransitionableState)realSubmitState, "cancel", "cancel");
            List loginProperties = CollectionUtils.wrapList((Object[])new String[]{"token"});
            BinderConfiguration loginBinder = this.createStateBinderConfiguration(loginProperties);
            ViewState viewLoginFormState = this.createViewState(flow, "viewLoginForm", "casRadiusLoginView", loginBinder);
            this.createStateModelBinding((TransitionableState)viewLoginFormState, "credential", RadiusTokenCredential.class);
            SetAction setPrincipalAction = this.createSetAction("viewScope.principal", "conversationScope.authentication.principal");
            viewLoginFormState.getEntryActionList().addAll(new Action[]{setPrincipalAction});
            this.createTransitionForState((TransitionableState)viewLoginFormState, "submit", "realSubmit", Map.of("bind", Boolean.TRUE, "validate", Boolean.TRUE));
        });
        this.registerMultifactorProviderAuthenticationWebflow(this.getLoginFlow(), MFA_RADIUS_EVENT_ID, this.casProperties.getAuthn().getMfa().getRadius().getId());
    }
}

