/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.adaptors.radius.web.flow.RadiusAuthenticationWebflowAction;
import org.apereo.cas.adaptors.radius.web.flow.RadiusAuthenticationWebflowEventResolver;
import org.apereo.cas.adaptors.radius.web.flow.RadiusMultifactorTrustedDeviceWebflowConfigurer;
import org.apereo.cas.adaptors.radius.web.flow.RadiusMultifactorWebflowConfigurer;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.trusted.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="radiusMfaConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(name={"cas.authn.mfa.radius.client.inet-address"})
public class RadiusMultifactorConfiguration {
    private static final int WEBFLOW_CONFIGURER_ORDER = 100;
    @Autowired
    @Qualifier(value="authenticationEventExecutionPlan")
    private ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private ObjectProvider<CasDelegatingWebflowEventResolver> initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="authenticationContextValidator")
    private ObjectProvider<MultifactorAuthenticationContextValidator> authenticationContextValidator;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private ObjectProvider<CasCookieBuilder> warnCookieGenerator;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="singleSignOnParticipationStrategy")
    private ObjectProvider<SingleSignOnParticipationStrategy> webflowSingleSignOnParticipationStrategy;

    @Bean
    public FlowDefinitionRegistry radiusFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)this.applicationContext, (FlowBuilderServices)this.flowBuilderServices.getObject());
        builder.setBasePath("classpath*:/webflow");
        builder.addFlowLocationPattern("/mfa-radius/*-webflow.xml");
        return builder.build();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"radiusAuthenticationWebflowAction"})
    public Action radiusAuthenticationWebflowAction() {
        return new RadiusAuthenticationWebflowAction(this.radiusAuthenticationWebflowEventResolver());
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"radiusAuthenticationWebflowEventResolver"})
    public CasWebflowEventResolver radiusAuthenticationWebflowEventResolver() {
        CasWebflowEventResolutionConfigurationContext context = CasWebflowEventResolutionConfigurationContext.builder().casDelegatingWebflowEventResolver((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getObject()).authenticationContextValidator((MultifactorAuthenticationContextValidator)this.authenticationContextValidator.getObject()).authenticationSystemSupport((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject()).centralAuthenticationService((CentralAuthenticationService)this.centralAuthenticationService.getObject()).servicesManager((ServicesManager)this.servicesManager.getObject()).singleSignOnParticipationStrategy((SingleSignOnParticipationStrategy)this.webflowSingleSignOnParticipationStrategy.getObject()).ticketRegistrySupport((TicketRegistrySupport)this.ticketRegistrySupport.getObject()).warnCookieGenerator((CasCookieBuilder)this.warnCookieGenerator.getObject()).authenticationRequestServiceSelectionStrategies((AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject()).registeredServiceAccessStrategyEnforcer((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).casProperties(this.casProperties).ticketRegistry((TicketRegistry)this.ticketRegistry.getObject()).applicationContext(this.applicationContext).authenticationEventExecutionPlan((AuthenticationEventExecutionPlan)this.authenticationEventExecutionPlan.getObject()).build();
        return new RadiusAuthenticationWebflowEventResolver(context, this.casProperties.getAuthn().getMfa().getRadius().getAllowedAuthenticationAttempts());
    }

    @ConditionalOnMissingBean(name={"radiusMultifactorWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer radiusMultifactorWebflowConfigurer() {
        RadiusMultifactorWebflowConfigurer cfg = new RadiusMultifactorWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.radiusFlowRegistry(), this.applicationContext, this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)this.applicationContext));
        cfg.setOrder(100);
        return cfg;
    }

    @Bean
    @ConditionalOnMissingBean(name={"radiusMultifactorCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer radiusMultifactorCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.radiusMultifactorWebflowConfigurer());
    }

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @ConditionalOnProperty(prefix="cas.authn.mfa.radius", name={"trusted-device-enabled"}, havingValue="true", matchIfMissing=true)
    @Configuration(value="radiusMultifactorTrustConfiguration")
    public class RadiusMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"radiusMultifactorTrustConfigurer"})
        @Bean
        @DependsOn(value={"defaultWebflowConfigurer"})
        public CasWebflowConfigurer radiusMultifactorTrustConfigurer() {
            RadiusMultifactorTrustedDeviceWebflowConfigurer cfg = new RadiusMultifactorTrustedDeviceWebflowConfigurer((FlowBuilderServices)RadiusMultifactorConfiguration.this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)RadiusMultifactorConfiguration.this.loginFlowDefinitionRegistry.getObject(), RadiusMultifactorConfiguration.this.radiusFlowRegistry(), RadiusMultifactorConfiguration.this.applicationContext, RadiusMultifactorConfiguration.this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)RadiusMultifactorConfiguration.this.applicationContext));
            cfg.setOrder(101);
            return cfg;
        }

        @Bean
        public CasWebflowExecutionPlanConfigurer radiusMultifactorTrustCasWebflowExecutionPlanConfigurer() {
            return plan -> plan.registerWebflowConfigurer(this.radiusMultifactorTrustConfigurer());
        }
    }
}

