/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.radius.RadiusClientFactory;
import org.apereo.cas.adaptors.radius.RadiusProtocol;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.adaptors.radius.authentication.RadiusMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.radius.authentication.RadiusTokenAuthenticationHandler;
import org.apereo.cas.adaptors.radius.authentication.RadiusTokenCredential;
import org.apereo.cas.adaptors.radius.server.NonBlockingRadiusServer;
import org.apereo.cas.adaptors.radius.server.RadiusServerConfigurationContext;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.handler.ByCredentialTypeAuthenticationHandlerResolver;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.RadiusMultifactorProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusClientProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusServerProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="radiusTokenAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(name={"cas.authn.mfa.radius.client.inet-address"})
public class RadiusTokenAuthenticationEventExecutionPlanConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="radiusBypassEvaluator")
    private ObjectProvider<MultifactorAuthenticationProviderBypassEvaluator> radiusBypassEvaluator;
    @Autowired
    @Qualifier(value="failureModeEvaluator")
    private ObjectProvider<MultifactorAuthenticationFailureModeEvaluator> failureModeEvaluator;

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"radiusMultifactorAuthenticationProvider"})
    public MultifactorAuthenticationProvider radiusMultifactorAuthenticationProvider() {
        RadiusMultifactorProperties radius = this.casProperties.getAuthn().getMfa().getRadius();
        RadiusMultifactorAuthenticationProvider p = new RadiusMultifactorAuthenticationProvider(this.radiusTokenServers());
        p.setBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)this.radiusBypassEvaluator.getObject());
        p.setFailureMode(radius.getFailureMode());
        p.setFailureModeEvaluator((MultifactorAuthenticationFailureModeEvaluator)this.failureModeEvaluator.getObject());
        p.setOrder(radius.getRank());
        p.setId(radius.getId());
        return p;
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"radiusTokenServers"})
    public List<RadiusServer> radiusTokenServers() {
        RadiusMultifactorProperties radius = this.casProperties.getAuthn().getMfa().getRadius();
        RadiusClientProperties client = radius.getClient();
        RadiusServerProperties server = radius.getServer();
        if (StringUtils.isBlank((CharSequence)client.getInetAddress())) {
            return new ArrayList<RadiusServer>(0);
        }
        RadiusClientFactory factory = new RadiusClientFactory(client.getAccountingPort(), client.getAuthenticationPort(), client.getSocketTimeout(), client.getInetAddress(), client.getSharedSecret());
        RadiusProtocol protocol = RadiusProtocol.valueOf((String)server.getProtocol());
        RadiusServerConfigurationContext context = RadiusServerConfigurationContext.builder().protocol(protocol).radiusClientFactory(factory).retries(server.getRetries()).nasIpAddress(server.getNasIpAddress()).nasIpv6Address(server.getNasIpv6Address()).nasPort(server.getNasPort()).nasPortId(server.getNasPortId()).nasIdentifier(server.getNasIdentifier()).nasRealPort(server.getNasRealPort()).nasPortType((long)server.getNasPortType()).build();
        NonBlockingRadiusServer impl = new NonBlockingRadiusServer(context);
        return CollectionUtils.wrapList((Object[])new RadiusServer[]{impl});
    }

    @ConditionalOnMissingBean(name={"radiusTokenPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory radiusTokenPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"radiusTokenAuthenticationHandler"})
    public AuthenticationHandler radiusTokenAuthenticationHandler() {
        RadiusMultifactorProperties radius = this.casProperties.getAuthn().getMfa().getRadius();
        return new RadiusTokenAuthenticationHandler(radius.getName(), (ServicesManager)this.servicesManager.getObject(), this.radiusTokenPrincipalFactory(), this.radiusTokenServers(), radius.isFailoverOnException(), radius.isFailoverOnAuthenticationFailure(), radius.getOrder());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"radiusAuthenticationMetaDataPopulator"})
    public AuthenticationMetaDataPopulator radiusAuthenticationMetaDataPopulator() {
        String attribute = this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute();
        return new AuthenticationContextAttributeMetaDataPopulator(attribute, this.radiusTokenAuthenticationHandler(), this.radiusMultifactorAuthenticationProvider().getId());
    }

    @ConditionalOnMissingBean(name={"radiusTokenAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope
    public AuthenticationEventExecutionPlanConfigurer radiusTokenAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            RadiusMultifactorProperties radius = this.casProperties.getAuthn().getMfa().getRadius();
            RadiusClientProperties client = radius.getClient();
            if (StringUtils.isNotBlank((CharSequence)client.getInetAddress())) {
                plan.registerAuthenticationHandler(this.radiusTokenAuthenticationHandler());
                plan.registerAuthenticationMetadataPopulator(this.radiusAuthenticationMetaDataPopulator());
                plan.registerAuthenticationHandlerResolver((AuthenticationHandlerResolver)new ByCredentialTypeAuthenticationHandlerResolver(new Class[]{RadiusTokenCredential.class}));
            }
        };
    }
}

