/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.radius.web.flow;

import java.util.Set;
import org.apereo.cas.web.flow.authentication.BaseMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.inspektr.audit.annotation.Audit;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RadiusAuthenticationWebflowEventResolver
extends BaseMultifactorAuthenticationProviderEventResolver {
    public static final String FLOW_SCOPE_ATTR_TOTAL_AUTHENTICATION_ATTEMPTS = "totalAuthenticationAttempts";
    private final long allowedAuthenticationAttempts;

    public RadiusAuthenticationWebflowEventResolver(CasWebflowEventResolutionConfigurationContext webflowEventResolutionConfigurationContext, long allowedAuthenticationAttempts) {
        super(webflowEventResolutionConfigurationContext);
        this.allowedAuthenticationAttempts = allowedAuthenticationAttempts;
    }

    public Set<Event> resolveInternal(RequestContext context) {
        return this.handleAuthenticationTransactionAndGrantTicketGrantingTicket(context);
    }

    @Audit(action="AUTHENTICATION_EVENT", actionResolverName="AUTHENTICATION_EVENT_ACTION_RESOLVER", resourceResolverName="AUTHENTICATION_EVENT_RESOURCE_RESOLVER")
    public Event resolveSingle(RequestContext context) {
        return super.resolveSingle(context);
    }

    protected Event getAuthenticationFailureErrorEvent(RequestContext context) {
        if (this.allowedAuthenticationAttempts <= 0L) {
            return super.getAuthenticationFailureErrorEvent(context);
        }
        long attempts = context.getFlowScope().getLong(FLOW_SCOPE_ATTR_TOTAL_AUTHENTICATION_ATTEMPTS, Long.valueOf(0L)) + 1L;
        if (attempts >= this.allowedAuthenticationAttempts) {
            context.getFlowScope().remove(FLOW_SCOPE_ATTR_TOTAL_AUTHENTICATION_ATTEMPTS);
            return new EventFactorySupport().event((Object)this, "cancel");
        }
        context.getFlowScope().put(FLOW_SCOPE_ATTR_TOTAL_AUTHENTICATION_ATTEMPTS, (Object)(attempts + 1L));
        return super.getAuthenticationFailureErrorEvent(context);
    }
}

