/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.radius.authentication;

import java.util.List;
import java.util.Map;
import javax.security.auth.login.FailedLoginException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jradius.packet.attribute.value.StringValue;
import org.apereo.cas.adaptors.radius.authentication.RadiusTokenCredential;
import org.apereo.cas.adaptors.radius.web.flow.BaseRadiusMultifactorAuthenticationTests;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@SpringBootTest(classes={BaseRadiusMultifactorAuthenticationTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.radius.server.protocol=PAP", "cas.authn.mfa.radius.client.shared-secret=testing123", "cas.authn.mfa.radius.client.inet-address=localhost"})
@Tag(value="Radius")
@EnabledOnOs(value={OS.LINUX})
public class RadiusTokenAuthenticationHandlerTests {
    @Autowired
    @Qualifier(value="radiusTokenAuthenticationHandler")
    private AuthenticationHandler authenticationHandler;

    @Test
    public void verifyOperation() throws Exception {
        RadiusTokenCredential c = new RadiusTokenCredential("Mellon");
        Assertions.assertTrue((boolean)this.authenticationHandler.supports((Credential)c));
        Assertions.assertTrue((boolean)this.authenticationHandler.supports(c.getClass()));
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        Assertions.assertThrows(FailedLoginException.class, () -> this.authenticationHandler.authenticate((Credential)c));
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser", Map.of("State", List.of(new StringValue("value"))));
        Authentication authn = CoreAuthenticationTestUtils.getAuthentication((Principal)principal);
        WebUtils.putAuthentication((Authentication)authn, (RequestContext)context);
        AuthenticationHandlerExecutionResult result = this.authenticationHandler.authenticate((Credential)c);
        Assertions.assertNotNull((Object)result);
    }
}

