/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.radius.web.flow;

import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.BaseCasWebflowMultifactorAuthenticationTests;
import org.apereo.cas.adaptors.radius.authentication.RadiusTokenCredential;
import org.apereo.cas.adaptors.radius.web.flow.BaseRadiusMultifactorAuthenticationTests;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.message.MessageContext;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockFlowExecutionContext;
import org.springframework.webflow.test.MockFlowSession;
import org.springframework.webflow.test.MockParameterMap;

@SpringBootTest(classes={BaseRadiusMultifactorAuthenticationTests.SharedTestConfiguration.class}, properties={"cas.authn.radius.client.shared-secret=NoSecret", "cas.authn.radius.client.inet-address=localhost,localguest", "cas.authn.mfa.radius.allowed-authentication-attempts=2", "cas.authn.mfa.radius.client.shared-secret=NoSecret", "cas.authn.mfa.radius.client.inet-address=localhost,localguest"})
@Tag(value="Radius")
public class RadiusAuthenticationWebflowEventResolverFailureTests
extends BaseCasWebflowMultifactorAuthenticationTests {
    @Autowired
    @Qualifier(value="radiusAuthenticationWebflowEventResolver")
    private CasWebflowEventResolver radiusAuthenticationWebflowEventResolver;
    private RequestContext context;

    @BeforeEach
    public void initialize() {
        this.context = (RequestContext)Mockito.mock(RequestContext.class);
        Mockito.when((Object)this.context.getConversationScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)this.context.getFlowScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)this.context.getRequestScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)this.context.getMessageContext()).thenReturn((Object)((MessageContext)Mockito.mock(MessageContext.class)));
        Mockito.when((Object)this.context.getRequestParameters()).thenReturn((Object)new MockParameterMap());
        Mockito.when((Object)this.context.getRequestParameters()).thenReturn((Object)new MockParameterMap());
        MockHttpServletRequest request = new MockHttpServletRequest();
        Mockito.when((Object)this.context.getExternalContext()).thenReturn((Object)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Mockito.when((Object)this.context.getFlowExecutionContext()).thenReturn((Object)new MockFlowExecutionContext((FlowSession)new MockFlowSession(new Flow("mockFlow"))));
        WebUtils.putServiceIntoFlowScope((RequestContext)this.context, (Service)CoreAuthenticationTestUtils.getWebApplicationService());
        TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        Authentication authentication = CoreAuthenticationTestUtils.getAuthentication();
        WebUtils.putAuthentication((Authentication)authentication, (RequestContext)this.context);
        AuthenticationResultBuilder builder = (AuthenticationResultBuilder)Mockito.mock(AuthenticationResultBuilder.class);
        Mockito.when((Object)builder.getInitialAuthentication()).thenReturn(Optional.of(authentication));
        Mockito.when((Object)builder.collect((Authentication)Mockito.any(Authentication.class))).thenReturn((Object)builder);
        WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)this.context);
    }

    @Test
    public void verifyFailsOperation() {
        WebUtils.putCredential((RequestContext)this.context, (Credential)new RadiusTokenCredential("token"));
        Event event = this.radiusAuthenticationWebflowEventResolver.resolveSingle(this.context);
        Assertions.assertEquals((Object)"error", (Object)event.getId());
        Assertions.assertTrue((boolean)this.context.getFlowScope().contains("totalAuthenticationAttempts"));
        event = this.radiusAuthenticationWebflowEventResolver.resolveSingle(this.context);
        Assertions.assertEquals((Object)"cancel", (Object)event.getId());
        Assertions.assertFalse((boolean)this.context.getFlowScope().contains("totalAuthenticationAttempts"));
    }
}

