/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.radius.web.flow;

import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.BaseCasWebflowMultifactorAuthenticationTests;
import org.apereo.cas.adaptors.radius.authentication.RadiusTokenCredential;
import org.apereo.cas.adaptors.radius.web.flow.BaseRadiusMultifactorAuthenticationTests;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.message.DefaultMessageContext;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@SpringBootTest(classes={BaseRadiusMultifactorAuthenticationTests.SharedTestConfiguration.class}, properties={"cas.authn.radius.client.shared-secret=NoSecret", "cas.authn.radius.client.inet-address=localhost,localguest", "cas.authn.mfa.radius.client.shared-secret=NoSecret", "cas.authn.mfa.radius.client.inet-address=localhost,localguest"})
@Tag(value="Radius")
public class RadiusAuthenticationWebflowEventResolverTests
extends BaseCasWebflowMultifactorAuthenticationTests {
    @Autowired
    @Qualifier(value="radiusAuthenticationWebflowEventResolver")
    private CasWebflowEventResolver radiusAuthenticationWebflowEventResolver;
    private MockRequestContext context;

    @BeforeEach
    public void initialize() {
        this.context = new MockRequestContext();
        DefaultMessageContext messageContext = (DefaultMessageContext)this.context.getMessageContext();
        messageContext.setMessageSource((MessageSource)Mockito.mock(MessageSource.class));
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        WebUtils.putServiceIntoFlowScope((RequestContext)this.context, (Service)CoreAuthenticationTestUtils.getWebApplicationService());
        TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        Authentication authentication = CoreAuthenticationTestUtils.getAuthentication();
        WebUtils.putAuthentication((Authentication)authentication, (RequestContext)this.context);
        AuthenticationResultBuilder builder = (AuthenticationResultBuilder)Mockito.mock(AuthenticationResultBuilder.class);
        Mockito.when((Object)builder.getInitialAuthentication()).thenReturn(Optional.of(authentication));
        Mockito.when((Object)builder.collect((Authentication)Mockito.any(Authentication.class))).thenReturn((Object)builder);
        WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)this.context);
    }

    @Test
    public void verifyOperation() {
        Event event = this.radiusAuthenticationWebflowEventResolver.resolveSingle((RequestContext)this.context);
        Assertions.assertEquals((Object)"success", (Object)event.getId());
    }

    @Test
    public void verifyFailsOperation() {
        WebUtils.putCredential((RequestContext)this.context, (Credential)new RadiusTokenCredential("token"));
        Event event = this.radiusAuthenticationWebflowEventResolver.resolveSingle((RequestContext)this.context);
        Assertions.assertEquals((Object)"error", (Object)event.getId());
    }
}

