/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.CasConfigurationPropertiesEnvironmentManager;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.apereo.cas.support.events.config.CasConfigurationModifiedEvent;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.web.BaseCasMvcEndpoint;
import org.apereo.cas.web.report.util.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.endpoint.EnvironmentEndpoint;
import org.springframework.cloud.endpoint.RefreshEndpoint;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

public class ConfigurationStateController
extends BaseCasMvcEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationStateController.class);
    private static final String VIEW_CONFIG = "monitoring/viewConfig";
    @Autowired(required=false)
    private RefreshEndpoint refreshEndpoint;
    @Autowired(required=false)
    private EnvironmentEndpoint environmentEndpoint;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired(required=false)
    @Qualifier(value="configurationPropertiesEnvironmentManager")
    private CasConfigurationPropertiesEnvironmentManager configurationPropertiesEnvironmentManager;

    public ConfigurationStateController(CasConfigurationProperties casProperties) {
        super("configstate", "/config", (MonitorProperties.BaseEndpoint)casProperties.getMonitor().getEndpoints().getConfigurationState(), casProperties);
    }

    @GetMapping
    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        HashMap<String, Boolean> model = new HashMap<String, Boolean>();
        String path = request.getContextPath();
        ControllerUtils.configureModelMapForConfigServerCloudBusEndpoints(path, model);
        model.put("enableRefresh", this.isRefreshEnabled());
        model.put("enableUpdate", this.isUpdateEnabled());
        return new ModelAndView(VIEW_CONFIG, model);
    }

    private Boolean isRefreshEnabled() {
        return !this.casProperties.getEvents().isTrackConfigurationModifications() && this.refreshEndpoint != null && this.refreshEndpoint.isEnabled() && (Boolean)this.environment.getProperty("spring.cloud.config.enabled", Boolean.class) != false;
    }

    private Boolean isUpdateEnabled() {
        return (Boolean)this.environment.getProperty("spring.cloud.config.enabled", Boolean.class) == false;
    }

    @GetMapping(value={"/getConfiguration"})
    @ResponseBody
    public Map getConfiguration(HttpServletRequest request, HttpServletResponse response) {
        TreeMap results = new TreeMap();
        this.ensureEndpointAccessIsAuthorized(request, response);
        if (this.environmentEndpoint == null || !this.environmentEndpoint.isEnabled()) {
            LOGGER.warn("Environment endpoint is either undefined or disabled");
            return results;
        }
        Pattern pattern = RegexUtils.createPattern((String)"(configService:|applicationConfig:).+(application|cas).+");
        Map environmentSettings = this.environmentEndpoint.invoke();
        environmentSettings.entrySet().stream().filter(entry -> pattern.matcher((CharSequence)entry.getKey()).matches()).forEach(entry -> {
            Map keys = (Map)entry.getValue();
            keys.keySet().forEach(key -> {
                if (!results.containsKey(key)) {
                    String propHolder = String.format("${%s}", key);
                    String value = this.environment.resolvePlaceholders(propHolder);
                    results.put(key, this.environmentEndpoint.sanitize(key, (Object)value));
                }
            });
        });
        return results;
    }

    @PostMapping(value={"/updateConfiguration"})
    @ResponseBody
    public void updateConfiguration(@RequestBody Map<String, Map<String, String>> jsonInput, HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        if (this.isUpdateEnabled().booleanValue()) {
            Map<String, String> newData = jsonInput.get("new");
            this.configurationPropertiesEnvironmentManager.savePropertyForStandaloneProfile(Pair.of((Object)newData.get("key"), (Object)newData.get("value")));
            this.eventPublisher.publishEvent((ApplicationEvent)new CasConfigurationModifiedEvent((Object)this, !this.casProperties.getEvents().isTrackConfigurationModifications()));
        }
    }
}

