/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import java.time.LocalDateTime;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.apereo.cas.configuration.model.support.mfa.TrustedDevicesMultifactorProperties;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.web.BaseCasMvcEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@ConditionalOnClass(value={MultifactorAuthenticationTrustStorage.class})
public class TrustedDevicesController
extends BaseCasMvcEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustedDevicesController.class);
    private final MultifactorAuthenticationTrustStorage mfaTrustEngine;

    public TrustedDevicesController(MultifactorAuthenticationTrustStorage mfaTrustEngine, CasConfigurationProperties casProperties) {
        super("trustedDevs", "/trustedDevs", (MonitorProperties.BaseEndpoint)casProperties.getMonitor().getEndpoints().getTrustedDevices(), casProperties);
        this.mfaTrustEngine = mfaTrustEngine;
    }

    @GetMapping
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        return new ModelAndView("monitoring/viewTrustedDevices");
    }

    @GetMapping(value={"/getRecords"})
    @ResponseBody
    public Set<MultifactorAuthenticationTrustRecord> getRecords(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        TrustedDevicesMultifactorProperties trusted = this.casProperties.getAuthn().getMfa().getTrusted();
        LocalDateTime onOrAfter = LocalDateTime.now().minus(trusted.getExpiration(), DateTimeUtils.toChronoUnit((TimeUnit)trusted.getTimeUnit()));
        this.mfaTrustEngine.expire(onOrAfter);
        return this.mfaTrustEngine.get(onOrAfter);
    }

    @PostMapping(value={"/revokeRecord"})
    @ResponseBody
    public Integer revokeRecord(@RequestParam String key, HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        this.mfaTrustEngine.expire(key);
        return HttpStatus.OK.value();
    }
}

