/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report.util;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apereo.cas.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public final class ControllerUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerUtils.class);

    public static void configureModelMapForConfigServerCloudBusEndpoints(String path, Map model) {
        model.put("refreshEndpoint", path + "/status/refresh");
        model.put("refreshMethod", "POST");
    }

    public static Optional<Pair<Resource, LoggerContext>> buildLoggerContext(Environment environment, ResourceLoader resourceLoader) {
        String logFile = environment.getProperty("logging.config", "classpath:/log4j2.xml");
        LOGGER.debug("Located logging configuration reference in the environment as [{}]", (Object)logFile);
        if (ResourceUtils.doesResourceExist((String)logFile, (ResourceLoader)resourceLoader)) {
            Resource logConfigurationFile = resourceLoader.getResource(logFile);
            LOGGER.debug("Loaded logging configuration resource [{}]. Initializing logger context...", (Object)logConfigurationFile);
            LoggerContext loggerContext = Configurator.initialize((String)"CAS", null, (URI)logConfigurationFile.getURI());
            LOGGER.debug("Installing log configuration listener to detect changes and update");
            loggerContext.getConfiguration().addListener(reconfigurable -> loggerContext.updateLoggers(reconfigurable.reconfigure()));
            return Optional.of(Pair.of((Object)logConfigurationFile, (Object)loggerContext));
        }
        LOGGER.warn("Logging configuration cannot be found in the environment settings");
        return Optional.empty();
    }

    @Generated
    private ControllerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

