/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.rest.BadRestRequestException;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RegexUtils;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="registeredServiceResourceRestController")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RegisteredServiceResource {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceResource.class);
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final ServiceFactory serviceFactory;
    private final ServicesManager servicesManager;
    private final String attributeName;
    private final String attributeValue;

    @PostMapping(value={"/v1/services"}, consumes={"application/json"})
    public ResponseEntity<String> createService(@RequestBody RegisteredService service, HttpServletRequest request, HttpServletResponse response) {
        try {
            Authentication auth = this.authenticateRequest(request, response);
            if (this.isAuthenticatedPrincipalAuthorized(auth)) {
                this.servicesManager.save(service);
                return new ResponseEntity(HttpStatus.OK);
            }
            return new ResponseEntity((Object)"Request is not authorized", HttpStatus.FORBIDDEN);
        }
        catch (AuthenticationException e) {
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.UNAUTHORIZED);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
    }

    private boolean isAuthenticatedPrincipalAuthorized(Authentication auth) {
        Map attributes = auth.getPrincipal().getAttributes();
        LOGGER.debug("Evaluating principal attributes [{}]", attributes.keySet());
        if (StringUtils.isBlank((CharSequence)this.attributeName) || StringUtils.isBlank((CharSequence)this.attributeValue)) {
            LOGGER.error("No attribute name or value is defined to authorize this request");
            return false;
        }
        Pattern pattern = RegexUtils.createPattern((String)this.attributeValue);
        if (attributes.containsKey(this.attributeName)) {
            Set values = CollectionUtils.toCollection(attributes.get(this.attributeName));
            return values.stream().anyMatch(t -> RegexUtils.matches((Pattern)pattern, (String)t.toString()));
        }
        return false;
    }

    private Authentication authenticateRequest(HttpServletRequest request, HttpServletResponse response) {
        BasicAuthExtractor extractor = new BasicAuthExtractor();
        JEEContext webContext = new JEEContext(request, response);
        Optional credentialsResult = extractor.extract((WebContext)webContext);
        if (credentialsResult.isPresent()) {
            UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)credentialsResult.get();
            LOGGER.debug("Received basic authentication request from credentials [{}]", (Object)credentials);
            UsernamePasswordCredential c = new UsernamePasswordCredential(credentials.getUsername(), credentials.getPassword());
            Service serviceRequest = this.serviceFactory.createService(request);
            AuthenticationResult result = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction(serviceRequest, new Credential[]{c});
            return result.getAuthentication();
        }
        throw new BadRestRequestException("Could not authenticate request");
    }

    @Generated
    public RegisteredServiceResource(AuthenticationSystemSupport authenticationSystemSupport, ServiceFactory serviceFactory, ServicesManager servicesManager, String attributeName, String attributeValue) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.serviceFactory = serviceFactory;
        this.servicesManager = servicesManager;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }
}

