/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest.config;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.rest.RestProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.support.rest.RegisteredServiceResource;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration(value="restServicesConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RestServicesConfiguration {
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ObjectProvider<ServiceFactory> webApplicationServiceFactory;

    @Bean
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter() {
        RegisteredServiceJsonSerializer serializer = new RegisteredServiceJsonSerializer();
        return new MappingJackson2HttpMessageConverter(serializer.getObjectMapper());
    }

    @Bean
    public RegisteredServiceResource registeredServiceResourceRestController() {
        RestProperties rest = this.casProperties.getRest();
        if (StringUtils.isBlank((CharSequence)rest.getAttributeName())) {
            throw new BeanCreationException("No attribute name is defined to enforce authorization when adding services via CAS REST APIs. This is likely due to misconfiguration in CAS settings where the attribute name definition is absent");
        }
        if (StringUtils.isBlank((CharSequence)rest.getAttributeValue())) {
            throw new BeanCreationException("No attribute value is defined to enforce authorization when adding services via CAS REST APIs. This is likely due to misconfiguration in CAS settings where the attribute value definition is absent");
        }
        return new RegisteredServiceResource((AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable(), (ServiceFactory)this.webApplicationServiceFactory.getIfAvailable(), (ServicesManager)this.servicesManager.getIfAvailable(), rest.getAttributeName(), rest.getAttributeValue());
    }
}

