/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest;

import java.util.HashMap;
import javax.security.auth.login.LoginException;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationManager;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.AuthenticationTransactionManager;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.DefaultAuthenticationSystemSupport;
import org.apereo.cas.authentication.DefaultAuthenticationTransactionManager;
import org.apereo.cas.authentication.DefaultPrincipalElectionStrategy;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.rest.factory.DefaultTicketGrantingTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.TicketGrantingTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.UsernamePasswordRestHttpRequestCredentialFactory;
import org.apereo.cas.support.rest.resources.TicketGrantingTicketResource;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;
import org.springframework.web.context.support.GenericWebApplicationContext;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class TicketGrantingTicketResourceTests {
    private static final String TICKETS_RESOURCE_URL = "/cas/v1/tickets";
    private static final String USERNAME = "username";
    private static final String OTHER_EXCEPTION = "Other exception";
    private static final String TEST_VALUE = "test";
    private static final String PASSWORD = "password";
    @Mock
    private CentralAuthenticationService casMock;
    @Mock
    private TicketRegistrySupport ticketSupport;
    @InjectMocks
    private TicketGrantingTicketResource ticketGrantingTicketResourceUnderTest;
    private MockMvc mockMvc;

    @Before
    public void initialize() {
        ApplicationEventPublisher publisher = (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class);
        AuthenticationManager manager = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.when((Object)manager.authenticate((AuthenticationTransaction)Mockito.any(AuthenticationTransaction.class))).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication());
        Mockito.when((Object)this.ticketSupport.getAuthenticationFrom(Mockito.anyString())).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication());
        this.ticketGrantingTicketResourceUnderTest = new TicketGrantingTicketResource((AuthenticationSystemSupport)new DefaultAuthenticationSystemSupport((AuthenticationTransactionManager)new DefaultAuthenticationTransactionManager(publisher, manager), (PrincipalElectionStrategy)new DefaultPrincipalElectionStrategy()), (RestHttpRequestCredentialFactory)new UsernamePasswordRestHttpRequestCredentialFactory(), this.casMock, (ServiceFactory)new WebApplicationServiceFactory(), (TicketGrantingTicketResourceEntityResponseFactory)new DefaultTicketGrantingTicketResourceEntityResponseFactory(), (ApplicationContext)new GenericWebApplicationContext());
        this.mockMvc = ((StandaloneMockMvcBuilder)MockMvcBuilders.standaloneSetup((Object[])new Object[]{this.ticketGrantingTicketResourceUnderTest}).defaultRequest((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).contextPath("/cas").contentType(MediaType.APPLICATION_FORM_URLENCODED))).build();
    }

    @Test
    public void verifyNormalCreationOfTGT() throws Exception {
        String expectedReturnEntityBody = "<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>201 CREATED</title></head><body><h1>TGT Created</h1><form action=\"http://localhost/cas/v1/tickets/TGT-1\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>";
        this.configureCasMockToCreateValidTGT();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.header().string("Location", "http://localhost/cas/v1/tickets/TGT-1")).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_HTML)).andExpect(MockMvcResultMatchers.content().string("<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>201 CREATED</title></head><body><h1>TGT Created</h1><form action=\"http://localhost/cas/v1/tickets/TGT-1\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>"));
    }

    @Test
    public void defaultCreationOfTGT() throws Throwable {
        String expectedReturnEntityBody = "<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>201 CREATED</title></head><body><h1>TGT Created</h1><form action=\"http://localhost/cas/v1/tickets/TGT-1\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>";
        this.configureCasMockToCreateValidTGT();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE}).accept(new MediaType[]{MediaType.ALL})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.header().string("Location", "http://localhost/cas/v1/tickets/TGT-1")).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_HTML)).andExpect(MockMvcResultMatchers.content().string("<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>201 CREATED</title></head><body><h1>TGT Created</h1><form action=\"http://localhost/cas/v1/tickets/TGT-1\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>"));
    }

    @Test
    public void verifyHtmlCreationOfTGT() throws Throwable {
        String expectedReturnEntityBody = "<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>201 CREATED</title></head><body><h1>TGT Created</h1><form action=\"http://localhost/cas/v1/tickets/TGT-1\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>";
        this.configureCasMockToCreateValidTGT();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE}).accept(new MediaType[]{MediaType.TEXT_HTML})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.header().string("Location", "http://localhost/cas/v1/tickets/TGT-1")).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_HTML)).andExpect(MockMvcResultMatchers.content().string("<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>201 CREATED</title></head><body><h1>TGT Created</h1><form action=\"http://localhost/cas/v1/tickets/TGT-1\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>"));
    }

    @Test
    public void verifyJsonCreationOfTGT() throws Throwable {
        String expectedReturnEntityBody = "TGT-1";
        this.configureCasMockToCreateValidTGT();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_UTF8})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.header().string("Location", "http://localhost/cas/v1/tickets/TGT-1")).andExpect(MockMvcResultMatchers.content().contentType(MediaType.APPLICATION_JSON_UTF8)).andExpect(MockMvcResultMatchers.content().string("TGT-1"));
    }

    @Test
    public void creationOfTGTWithAuthenticationException() throws Exception {
        this.configureCasMockTGTCreationToThrowAuthenticationException();
        String content = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE})).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andReturn().getResponse().getContentAsString();
        Assert.assertTrue((boolean)content.contains("LoginException"));
    }

    @Test
    public void creationOfTGTWithUnexpectedRuntimeException() throws Exception {
        this.configureCasMockTGTCreationToThrow(new RuntimeException(OTHER_EXCEPTION));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE})).andExpect(MockMvcResultMatchers.status().is5xxServerError()).andExpect(MockMvcResultMatchers.content().string(OTHER_EXCEPTION));
    }

    @Test
    public void creationOfTGTWithBadPayload() throws Exception {
        this.configureCasMockTGTCreationToThrow(new RuntimeException(OTHER_EXCEPTION));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param("no_username_param", new String[]{TEST_VALUE}).param("no_password_param", new String[]{TEST_VALUE})).andExpect(MockMvcResultMatchers.status().is4xxClientError());
    }

    @Test
    public void deletionOfTGT() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/cas/v1/tickets/TGT-1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    private void configureCasMockToCreateValidTGT() {
        TicketGrantingTicket tgt = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        Mockito.when((Object)tgt.getId()).thenReturn((Object)"TGT-1");
        Mockito.when((Object)this.casMock.createTicketGrantingTicket((AuthenticationResult)Mockito.any(AuthenticationResult.class))).thenReturn((Object)tgt);
    }

    private void configureCasMockTGTCreationToThrowAuthenticationException() {
        HashMap<String, LoginException> handlerErrors = new HashMap<String, LoginException>(1);
        handlerErrors.put("TestCaseAuthenticationHandler", new LoginException("Login failed"));
        Mockito.when((Object)this.casMock.createTicketGrantingTicket((AuthenticationResult)Mockito.any(AuthenticationResult.class))).thenThrow(new Throwable[]{new AuthenticationException(handlerErrors)});
    }

    private void configureCasMockTGTCreationToThrow(Exception e) {
        Mockito.when((Object)this.casMock.createTicketGrantingTicket((AuthenticationResult)Mockito.any(AuthenticationResult.class))).thenThrow(new Throwable[]{e});
    }
}

