/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest;

import java.util.Collection;
import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.DefaultAuthenticationResultBuilder;
import org.apereo.cas.authentication.DefaultPrincipalElectionStrategy;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.rest.factory.DefaultUserAuthenticationResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.UserAuthenticationResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.UsernamePasswordRestHttpRequestCredentialFactory;
import org.apereo.cas.support.rest.resources.UserAuthenticationResource;
import org.apereo.cas.util.CollectionUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;

@RunWith(value=MockitoJUnitRunner.Silent.class)
@DirtiesContext
public class UserAuthenticationResourceTests {
    private static final String TICKETS_RESOURCE_URL = "/cas/v1/users";
    @Mock
    private AuthenticationSystemSupport authenticationSupport;
    @InjectMocks
    private UserAuthenticationResource userAuthenticationResource;
    private MockMvc mockMvc;

    @Before
    public void initialize() {
        this.userAuthenticationResource = new UserAuthenticationResource(this.authenticationSupport, (RestHttpRequestCredentialFactory)new UsernamePasswordRestHttpRequestCredentialFactory(), (ServiceFactory)new WebApplicationServiceFactory(), (UserAuthenticationResourceEntityResponseFactory)new DefaultUserAuthenticationResourceEntityResponseFactory(), (ApplicationContext)new GenericApplicationContext());
        this.mockMvc = ((StandaloneMockMvcBuilder)MockMvcBuilders.standaloneSetup((Object[])new Object[]{this.userAuthenticationResource}).defaultRequest((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).contextPath("/cas").contentType(MediaType.APPLICATION_FORM_URLENCODED))).build();
    }

    @Test
    public void verifyStatus() throws Exception {
        AuthenticationResult result = new DefaultAuthenticationResultBuilder().collect(CoreAuthenticationTestUtils.getAuthentication()).build((PrincipalElectionStrategy)new DefaultPrincipalElectionStrategy());
        Mockito.when((Object)this.authenticationSupport.handleAndFinalizeSingleAuthenticationTransaction((Service)Mockito.any(), Mockito.anyCollection())).thenReturn((Object)result);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param("username", new String[]{"casuser"}).param("password", new String[]{"Mellon"})).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void verifyStatusAuthnFails() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param("username", new String[]{"casuser"}).param("password", new String[]{"Mellon"})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void verifyStatusAuthnException() throws Exception {
        AuthenticationException ex = new AuthenticationException(CollectionUtils.wrap((String)"error", (Object)new FailedLoginException()));
        Mockito.when((Object)this.authenticationSupport.handleAndFinalizeSingleAuthenticationTransaction((Service)Mockito.any(), (Collection)Mockito.any(Collection.class))).thenThrow(new Throwable[]{ex});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param("username", new String[]{"casuser"}).param("password", new String[]{"Mellon"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }
}

