/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest;

import java.util.HashMap;
import javax.security.auth.login.LoginException;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationManager;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilderFactory;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.AuthenticationTransactionFactory;
import org.apereo.cas.authentication.AuthenticationTransactionManager;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.DefaultAuthenticationResultBuilderFactory;
import org.apereo.cas.authentication.DefaultAuthenticationSystemSupport;
import org.apereo.cas.authentication.DefaultAuthenticationTransactionFactory;
import org.apereo.cas.authentication.DefaultAuthenticationTransactionManager;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.DefaultPrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.rest.factory.CasProtocolServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.ServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.UsernamePasswordRestHttpRequestCredentialFactory;
import org.apereo.cas.support.rest.resources.ServiceTicketResource;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.DefaultArgumentExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;

@ExtendWith(value={MockitoExtension.class})
@Tag(value="RestfulApi")
public class ServiceTicketResourceTests {
    private static final String TICKETS_RESOURCE_URL = "/cas/v1/tickets";
    private static final String OTHER_EXCEPTION = "Other exception";
    private static final String SERVICE = "service";
    private static final String RENEW = "renew";
    private static final String TEST_VALUE = "test";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    @Mock
    private CentralAuthenticationService casMock;
    @Mock
    private TicketRegistrySupport ticketSupport;
    @InjectMocks
    private ServiceTicketResource serviceTicketResource;
    private MockMvc mockMvc;

    @BeforeEach
    public void initialize() {
        AuthenticationManager mgmr = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.lenient().when((Object)mgmr.authenticate((AuthenticationTransaction)Mockito.any(AuthenticationTransaction.class))).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication());
        Mockito.lenient().when((Object)this.ticketSupport.getAuthenticationFrom(Mockito.anyString())).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication());
        ApplicationEventPublisher publisher = (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class);
        this.serviceTicketResource = new ServiceTicketResource((AuthenticationSystemSupport)new DefaultAuthenticationSystemSupport((AuthenticationTransactionManager)new DefaultAuthenticationTransactionManager(publisher, mgmr), (PrincipalElectionStrategy)new DefaultPrincipalElectionStrategy(), (AuthenticationResultBuilderFactory)new DefaultAuthenticationResultBuilderFactory(), (AuthenticationTransactionFactory)new DefaultAuthenticationTransactionFactory()), this.ticketSupport, (ArgumentExtractor)new DefaultArgumentExtractor((ServiceFactory)new WebApplicationServiceFactory()), (ServiceTicketResourceEntityResponseFactory)new CasProtocolServiceTicketResourceEntityResponseFactory(this.casMock), (RestHttpRequestCredentialFactory)new UsernamePasswordRestHttpRequestCredentialFactory(), (ApplicationContext)new GenericApplicationContext());
        this.mockMvc = ((StandaloneMockMvcBuilder)MockMvcBuilders.standaloneSetup((Object[])new Object[]{this.serviceTicketResource}).defaultRequest((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).contextPath("/cas").accept(new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED, MediaType.TEXT_PLAIN}).contentType(MediaType.APPLICATION_FORM_URLENCODED))).build();
    }

    @Test
    public void normalCreationOfST() throws Exception {
        this.configureCasMockToCreateValidST();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/cas/v1/tickets/TGT-1", (Object[])new Object[0]).param(SERVICE, new String[]{CoreAuthenticationTestUtils.getService().getId()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/x-www-form-urlencoded;charset=ISO-8859-1")).andExpect(MockMvcResultMatchers.content().string("ST-1"));
    }

    @Test
    public void normalCreationOfSTWithRenew() throws Exception {
        this.configureCasMockToCreateValidST();
        String content = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/cas/v1/tickets/TGT-1", (Object[])new Object[0]).param(SERVICE, new String[]{CoreAuthenticationTestUtils.getService().getId()}).param(RENEW, new String[]{"true"}).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/x-www-form-urlencoded;charset=ISO-8859-1")).andExpect(MockMvcResultMatchers.content().string("ST-1")).andReturn().getResponse().getContentAsString();
        Assertions.assertTrue((boolean)content.contains("ST-1"));
    }

    @Test
    public void creationOfSTWithInvalidTicketException() throws Exception {
        this.configureCasMockSTCreationToThrow((Throwable)new InvalidTicketException("TGT-1"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/cas/v1/tickets/TGT-1", (Object[])new Object[0]).param(SERVICE, new String[]{CoreAuthenticationTestUtils.getService().getId()})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void creationOfSTWithGeneralException() throws Exception {
        this.configureCasMockSTCreationToThrow(new RuntimeException(OTHER_EXCEPTION));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/cas/v1/tickets/TGT-1", (Object[])new Object[0]).param(SERVICE, new String[]{CoreAuthenticationTestUtils.getService().getId()})).andExpect(MockMvcResultMatchers.status().is5xxServerError()).andExpect(MockMvcResultMatchers.content().string(OTHER_EXCEPTION));
    }

    @Test
    public void creationOfSTWithBadRequestException() throws Exception {
        this.configureCasMockToCreateValidST();
        String content = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/cas/v1/tickets/TGT-1", (Object[])new Object[0]).param(SERVICE, new String[]{CoreAuthenticationTestUtils.getService().getId()}).param(RENEW, new String[]{"true"})).andExpect(MockMvcResultMatchers.status().isBadRequest()).andReturn().getResponse().getContentAsString();
        Assertions.assertTrue((boolean)content.contains("No credentials"));
    }

    @Test
    public void creationOfSTWithAuthenticationException() throws Exception {
        this.configureCasMockSTCreationToThrowAuthenticationException();
        String content = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/cas/v1/tickets/TGT-1", (Object[])new Object[0]).param(SERVICE, new String[]{CoreAuthenticationTestUtils.getService().getId()}).param(RENEW, new String[]{"true"}).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE})).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andReturn().getResponse().getContentAsString();
        Assertions.assertTrue((boolean)content.contains("Login failed"));
    }

    private void configureCasMockSTCreationToThrow(Throwable e) {
        Mockito.when((Object)this.casMock.grantServiceTicket(Mockito.anyString(), (Service)Mockito.any(Service.class), (AuthenticationResult)Mockito.any(AuthenticationResult.class))).thenThrow(new Throwable[]{e});
    }

    private void configureCasMockToCreateValidST() {
        ServiceTicket st = (ServiceTicket)Mockito.mock(ServiceTicket.class);
        Mockito.lenient().when((Object)st.getId()).thenReturn((Object)"ST-1");
        Mockito.lenient().when((Object)this.casMock.grantServiceTicket(Mockito.anyString(), (Service)Mockito.any(Service.class), (AuthenticationResult)Mockito.any(AuthenticationResult.class))).thenReturn((Object)st);
    }

    private void configureCasMockSTCreationToThrowAuthenticationException() {
        HashMap<String, LoginException> handlerErrors = new HashMap<String, LoginException>(1);
        handlerErrors.put("TestCaseAuthenticationHandler", new LoginException("Login failed"));
        Mockito.when((Object)this.casMock.grantServiceTicket(Mockito.anyString(), (Service)Mockito.any(Service.class), (AuthenticationResult)Mockito.any(AuthenticationResult.class))).thenThrow(new Throwable[]{new AuthenticationException(handlerErrors)});
    }
}

