/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationManager;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilderFactory;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.AuthenticationTransactionFactory;
import org.apereo.cas.authentication.AuthenticationTransactionManager;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationResultBuilderFactory;
import org.apereo.cas.authentication.DefaultAuthenticationSystemSupport;
import org.apereo.cas.authentication.DefaultAuthenticationTransactionFactory;
import org.apereo.cas.authentication.DefaultAuthenticationTransactionManager;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationTriggerSelectionStrategy;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.DefaultPrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.rest.authentication.DefaultRestAuthenticationService;
import org.apereo.cas.rest.authentication.RestAuthenticationService;
import org.apereo.cas.rest.factory.DefaultTicketGrantingTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.TicketGrantingTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.UsernamePasswordRestHttpRequestCredentialFactory;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.rest.resources.TicketGrantingTicketResource;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.validation.AuthenticationContextValidationResult;
import org.apereo.cas.validation.RequestedAuthenticationContextValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;
import org.springframework.util.MultiValueMap;

@ExtendWith(value={MockitoExtension.class})
@Tag(value="RestfulApi")
public class TicketGrantingTicketResourceTests {
    private static final String TICKETS_RESOURCE_URL = "/cas/v1/tickets";
    private static final String USERNAME = "username";
    private static final String OTHER_EXCEPTION = "Other exception";
    private static final String TEST_VALUE = "test";
    private static final String PASSWORD = "password";
    @Mock
    private MultifactorAuthenticationTriggerSelectionStrategy multifactorTriggerSelectionStrategy;
    @Mock
    private CentralAuthenticationService casMock;
    @Mock
    private TicketRegistrySupport ticketSupport;
    @Mock
    private ServicesManager servicesManager;
    @Mock
    private RequestedAuthenticationContextValidator requestedContextValidator;
    @InjectMocks
    private TicketGrantingTicketResource ticketGrantingTicketResourceUnderTest;
    private MockMvc mockMvc;

    @BeforeEach
    public void initialize() {
        UsernamePasswordRestHttpRequestCredentialFactory httpRequestCredentialFactory = new UsernamePasswordRestHttpRequestCredentialFactory(){

            public List<Credential> fromAuthentication(HttpServletRequest request, MultiValueMap<String, String> requestBody, Authentication authentication, MultifactorAuthenticationProvider provider) {
                if (provider.getId().contains("unknown")) {
                    return List.of();
                }
                return List.of(new UsernamePasswordCredential("mfa-user", "mfa-user"));
            }
        };
        ApplicationEventPublisher publisher = (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class);
        AuthenticationManager manager = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.lenient().when((Object)manager.authenticate((AuthenticationTransaction)Mockito.any(AuthenticationTransaction.class))).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication());
        Mockito.lenient().when((Object)this.ticketSupport.getAuthenticationFrom(Mockito.anyString())).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication());
        Mockito.lenient().when((Object)this.requestedContextValidator.validateAuthenticationContext((HttpServletRequest)Mockito.any(), (RegisteredService)Mockito.any(), (Authentication)Mockito.any(), (Service)Mockito.any())).thenReturn((Object)AuthenticationContextValidationResult.builder().success(true).build());
        Mockito.lenient().when((Object)this.multifactorTriggerSelectionStrategy.resolve((HttpServletRequest)Mockito.any(), (RegisteredService)Mockito.any(), (Authentication)Mockito.any(), (Service)Mockito.any())).thenReturn(Optional.empty());
        DefaultAuthenticationSystemSupport authenticationSystemSupport = new DefaultAuthenticationSystemSupport((AuthenticationTransactionManager)new DefaultAuthenticationTransactionManager(publisher, manager), (PrincipalElectionStrategy)new DefaultPrincipalElectionStrategy(), (AuthenticationResultBuilderFactory)new DefaultAuthenticationResultBuilderFactory(), (AuthenticationTransactionFactory)new DefaultAuthenticationTransactionFactory());
        DefaultRestAuthenticationService api = new DefaultRestAuthenticationService((AuthenticationSystemSupport)authenticationSystemSupport, (RestHttpRequestCredentialFactory)httpRequestCredentialFactory, (ServiceFactory)new WebApplicationServiceFactory(), this.multifactorTriggerSelectionStrategy, this.servicesManager, this.requestedContextValidator);
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        this.ticketGrantingTicketResourceUnderTest = new TicketGrantingTicketResource((RestAuthenticationService)api, this.casMock, (TicketGrantingTicketResourceEntityResponseFactory)new DefaultTicketGrantingTicketResourceEntityResponseFactory(), (ApplicationContext)applicationContext, (LogoutManager)Mockito.mock(LogoutManager.class));
        this.mockMvc = ((StandaloneMockMvcBuilder)MockMvcBuilders.standaloneSetup((Object[])new Object[]{this.ticketGrantingTicketResourceUnderTest}).defaultRequest((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).contextPath("/cas").contentType(MediaType.APPLICATION_FORM_URLENCODED))).build();
    }

    @Test
    public void verifyNormalCreationOfTGT() throws Exception {
        String expectedReturnEntityBody = "<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>201 CREATED</title></head><body><h1>TGT Created</h1><form action=\"http://localhost/cas/v1/tickets/TGT-1\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>";
        this.configureCasMockToCreateValidTGT();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.header().string("Location", "http://localhost/cas/v1/tickets/TGT-1")).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_HTML)).andExpect(MockMvcResultMatchers.content().string("<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>201 CREATED</title></head><body><h1>TGT Created</h1><form action=\"http://localhost/cas/v1/tickets/TGT-1\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>"));
    }

    @Test
    public void defaultCreationOfTGT() throws Throwable {
        String expectedReturnEntityBody = "<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>201 CREATED</title></head><body><h1>TGT Created</h1><form action=\"http://localhost/cas/v1/tickets/TGT-1\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>";
        this.configureCasMockToCreateValidTGT();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE}).accept(new MediaType[]{MediaType.ALL})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.header().string("Location", "http://localhost/cas/v1/tickets/TGT-1")).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_HTML)).andExpect(MockMvcResultMatchers.content().string("<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>201 CREATED</title></head><body><h1>TGT Created</h1><form action=\"http://localhost/cas/v1/tickets/TGT-1\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>"));
    }

    @Test
    public void verifyHtmlCreationOfTGT() throws Throwable {
        String expectedReturnEntityBody = "<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>201 CREATED</title></head><body><h1>TGT Created</h1><form action=\"http://localhost/cas/v1/tickets/TGT-1\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>";
        this.configureCasMockToCreateValidTGT();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE}).accept(new MediaType[]{MediaType.TEXT_HTML})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.header().string("Location", "http://localhost/cas/v1/tickets/TGT-1")).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_HTML)).andExpect(MockMvcResultMatchers.content().string("<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>201 CREATED</title></head><body><h1>TGT Created</h1><form action=\"http://localhost/cas/v1/tickets/TGT-1\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>"));
    }

    @Test
    public void verifyJsonCreationOfTGT() throws Throwable {
        String expectedReturnEntityBody = "TGT-1";
        this.configureCasMockToCreateValidTGT();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.header().string("Location", "http://localhost/cas/v1/tickets/TGT-1")).andExpect(MockMvcResultMatchers.content().contentType(MediaType.APPLICATION_JSON)).andExpect(MockMvcResultMatchers.content().string("TGT-1"));
    }

    @Test
    public void verifyCreateTgtWithMfa() throws Exception {
        Mockito.when((Object)this.requestedContextValidator.validateAuthenticationContext((HttpServletRequest)Mockito.any(), (RegisteredService)Mockito.any(), (Authentication)Mockito.any(), (Service)Mockito.any())).thenReturn((Object)AuthenticationContextValidationResult.builder().success(false).build());
        Mockito.when((Object)this.multifactorTriggerSelectionStrategy.resolve((HttpServletRequest)Mockito.any(), (RegisteredService)Mockito.any(), (Authentication)Mockito.any(), (Service)Mockito.any())).thenReturn(Optional.of(new TestMultifactorAuthenticationProvider()));
        String expectedReturnEntityBody = "TGT-1";
        this.configureCasMockToCreateValidTGT();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.header().string("Location", "http://localhost/cas/v1/tickets/TGT-1")).andExpect(MockMvcResultMatchers.content().contentType(MediaType.APPLICATION_JSON)).andExpect(MockMvcResultMatchers.content().string("TGT-1"));
    }

    @Test
    public void creationOfTGTWithAuthenticationException() throws Exception {
        this.configureCasMockTGTCreationToThrowAuthenticationException();
        String content = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE})).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andReturn().getResponse().getContentAsString();
        Assertions.assertTrue((boolean)content.contains("Login failed"));
    }

    @Test
    public void creationOfTGTWithUnexpectedRuntimeException() throws Exception {
        this.configureCasMockTGTCreationToThrow(new RuntimeException(OTHER_EXCEPTION));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param(USERNAME, new String[]{TEST_VALUE}).param(PASSWORD, new String[]{TEST_VALUE})).andExpect(MockMvcResultMatchers.status().is5xxServerError()).andExpect(MockMvcResultMatchers.content().string(OTHER_EXCEPTION));
    }

    @Test
    public void creationOfTGTWithBadPayload() throws Exception {
        this.configureCasMockTGTCreationToThrow(new RuntimeException(OTHER_EXCEPTION));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param("no_username_param", new String[]{TEST_VALUE}).param("no_password_param", new String[]{TEST_VALUE})).andExpect(MockMvcResultMatchers.status().is4xxClientError());
    }

    @Test
    public void deletionOfTGT() throws Exception {
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        Mockito.when((Object)this.casMock.getTicket(Mockito.anyString(), (Class)Mockito.any())).thenReturn((Object)tgt);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/cas/v1/tickets/TGT-1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    private void configureCasMockToCreateValidTGT() {
        TicketGrantingTicket tgt = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        Mockito.when((Object)tgt.getId()).thenReturn((Object)"TGT-1");
        Mockito.when((Object)this.casMock.createTicketGrantingTicket((AuthenticationResult)Mockito.any(AuthenticationResult.class))).thenReturn((Object)tgt);
    }

    private void configureCasMockTGTCreationToThrowAuthenticationException() {
        HashMap<String, LoginException> handlerErrors = new HashMap<String, LoginException>(1);
        handlerErrors.put("TestCaseAuthenticationHandler", new LoginException("Login failed"));
        Mockito.when((Object)this.casMock.createTicketGrantingTicket((AuthenticationResult)Mockito.any(AuthenticationResult.class))).thenThrow(new Throwable[]{new AuthenticationException(handlerErrors)});
    }

    private void configureCasMockTGTCreationToThrow(Exception e) {
        Mockito.lenient().when((Object)this.casMock.createTicketGrantingTicket((AuthenticationResult)Mockito.any(AuthenticationResult.class))).thenThrow(new Throwable[]{e});
    }
}

