/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest;

import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.support.rest.resources.TicketStatusResource;
import org.apereo.cas.ticket.InvalidTicketException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;

@ExtendWith(value={MockitoExtension.class})
@Tag(value="RestfulApi")
public class TicketStatusResourceTests {
    private static final String TICKETS_RESOURCE_URL = "/cas/v1/tickets";
    @Mock
    private CentralAuthenticationService casMock;
    @InjectMocks
    private TicketStatusResource ticketStatusResource;
    private MockMvc mockMvc;

    @BeforeEach
    public void initialize() {
        this.ticketStatusResource = new TicketStatusResource(this.casMock);
        this.mockMvc = ((StandaloneMockMvcBuilder)MockMvcBuilders.standaloneSetup((Object[])new Object[]{this.ticketStatusResource}).defaultRequest((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).contextPath("/cas").contentType(MediaType.APPLICATION_FORM_URLENCODED))).build();
    }

    @Test
    public void verifyStatus() throws Exception {
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        Mockito.when((Object)this.casMock.getTicket(Mockito.anyString())).thenReturn((Object)tgt);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/v1/tickets/TGT-1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(tgt.getId()));
    }

    @Test
    public void verifyStatusNotFound() throws Exception {
        Mockito.when((Object)this.casMock.getTicket(Mockito.anyString())).thenThrow(InvalidTicketException.class);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/v1/tickets/TGT-1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void verifyStatusError() throws Exception {
        Mockito.when((Object)this.casMock.getTicket(Mockito.anyString())).thenThrow(RuntimeException.class);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/cas/v1/tickets/TGT-1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }
}

