/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest;

import java.util.List;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationResultBuilder;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationTriggerSelectionStrategy;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.DefaultPrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.rest.authentication.DefaultRestAuthenticationService;
import org.apereo.cas.rest.authentication.RestAuthenticationService;
import org.apereo.cas.rest.factory.DefaultUserAuthenticationResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.UserAuthenticationResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.UsernamePasswordRestHttpRequestCredentialFactory;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.rest.resources.UserAuthenticationResource;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.AuthenticationContextValidationResult;
import org.apereo.cas.validation.RequestedAuthenticationContextValidator;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;
import org.springframework.util.MultiValueMap;

@ExtendWith(value={MockitoExtension.class})
@Tag(value="RestfulApiAuthentication")
public class UserAuthenticationResourceTests {
    private static final String TICKETS_RESOURCE_URL = "/cas/v1/users";
    @Mock
    private AuthenticationSystemSupport authenticationSupport;
    @Mock
    private ServicesManager servicesManager;
    @Mock
    private MultifactorAuthenticationTriggerSelectionStrategy multifactorTriggerSelectionStrategy;
    @Mock
    private RequestedAuthenticationContextValidator requestedContextValidator;
    @InjectMocks
    private UserAuthenticationResource userAuthenticationResource;
    private MockMvc mockMvc;

    @BeforeEach
    public void initialize() {
        UsernamePasswordRestHttpRequestCredentialFactory httpRequestCredentialFactory = new UsernamePasswordRestHttpRequestCredentialFactory(){

            public List<Credential> fromAuthentication(HttpServletRequest request, MultiValueMap<String, String> requestBody, Authentication authentication, MultifactorAuthenticationProvider provider) {
                if (provider.getId().contains("unknown")) {
                    return List.of();
                }
                return List.of(new UsernamePasswordCredential("mfa-user", "mfa-user"));
            }
        };
        DefaultRestAuthenticationService api = new DefaultRestAuthenticationService(this.authenticationSupport, (RestHttpRequestCredentialFactory)httpRequestCredentialFactory, (ServiceFactory)new WebApplicationServiceFactory(), this.multifactorTriggerSelectionStrategy, this.servicesManager, this.requestedContextValidator);
        this.userAuthenticationResource = new UserAuthenticationResource((RestAuthenticationService)api, (UserAuthenticationResourceEntityResponseFactory)new DefaultUserAuthenticationResourceEntityResponseFactory(), (ApplicationContext)new GenericApplicationContext());
        this.mockMvc = ((StandaloneMockMvcBuilder)MockMvcBuilders.standaloneSetup((Object[])new Object[]{this.userAuthenticationResource}).defaultRequest((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).contextPath("/cas").contentType(MediaType.APPLICATION_FORM_URLENCODED))).build();
    }

    @Test
    public void verifyAuthWithMfaFails() throws Exception {
        AuthenticationResultBuilder builder = new DefaultAuthenticationResultBuilder().collect(CoreAuthenticationTestUtils.getAuthentication());
        Mockito.when((Object)this.authenticationSupport.handleInitialAuthenticationTransaction((Service)Mockito.any(), (Credential[])Mockito.any())).thenReturn((Object)builder);
        Mockito.when((Object)this.requestedContextValidator.validateAuthenticationContext((HttpServletRequest)Mockito.any(), (RegisteredService)Mockito.any(), (Authentication)Mockito.any(), (Service)Mockito.any())).thenReturn((Object)AuthenticationContextValidationResult.builder().success(false).build());
        Mockito.when((Object)this.multifactorTriggerSelectionStrategy.resolve((HttpServletRequest)Mockito.any(), (RegisteredService)Mockito.any(), (Authentication)Mockito.any(), (Service)Mockito.any())).thenReturn(Optional.of(new TestMultifactorAuthenticationProvider("mfa-unknown")));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param("username", new String[]{"casuser"}).param("password", new String[]{"Mellon"})).andExpect(MockMvcResultMatchers.status().is4xxClientError());
    }

    @Test
    public void verifyAuthWithMfa() throws Exception {
        AuthenticationResultBuilder builder = new DefaultAuthenticationResultBuilder().collect(CoreAuthenticationTestUtils.getAuthentication());
        AuthenticationResult result = builder.build((PrincipalElectionStrategy)new DefaultPrincipalElectionStrategy());
        Mockito.when((Object)this.authenticationSupport.finalizeAuthenticationTransaction((Service)Mockito.any(), Mockito.anyCollection())).thenReturn((Object)result);
        Mockito.when((Object)this.authenticationSupport.handleInitialAuthenticationTransaction((Service)Mockito.any(), (Credential[])Mockito.any())).thenReturn((Object)builder);
        Mockito.when((Object)this.requestedContextValidator.validateAuthenticationContext((HttpServletRequest)Mockito.any(), (RegisteredService)Mockito.any(), (Authentication)Mockito.any(), (Service)Mockito.any())).thenReturn((Object)AuthenticationContextValidationResult.builder().success(false).build());
        Mockito.when((Object)this.multifactorTriggerSelectionStrategy.resolve((HttpServletRequest)Mockito.any(), (RegisteredService)Mockito.any(), (Authentication)Mockito.any(), (Service)Mockito.any())).thenReturn(Optional.of(new TestMultifactorAuthenticationProvider()));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param("username", new String[]{"casuser"}).param("password", new String[]{"Mellon"})).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void verifyStatus() throws Exception {
        AuthenticationResultBuilder builder = new DefaultAuthenticationResultBuilder().collect(CoreAuthenticationTestUtils.getAuthentication());
        AuthenticationResult result = builder.build((PrincipalElectionStrategy)new DefaultPrincipalElectionStrategy());
        Mockito.when((Object)this.authenticationSupport.finalizeAuthenticationTransaction((Service)Mockito.any(), Mockito.anyCollection())).thenReturn((Object)result);
        Mockito.when((Object)this.authenticationSupport.handleInitialAuthenticationTransaction((Service)Mockito.any(), (Credential[])Mockito.any())).thenReturn((Object)builder);
        Mockito.when((Object)this.authenticationSupport.finalizeAllAuthenticationTransactions((AuthenticationResultBuilder)Mockito.any(), (Service)Mockito.any())).thenReturn((Object)result);
        Mockito.when((Object)this.requestedContextValidator.validateAuthenticationContext((HttpServletRequest)Mockito.any(), (RegisteredService)Mockito.any(), (Authentication)Mockito.any(), (Service)Mockito.any())).thenReturn((Object)AuthenticationContextValidationResult.builder().success(false).build());
        Mockito.when((Object)this.multifactorTriggerSelectionStrategy.resolve((HttpServletRequest)Mockito.any(), (RegisteredService)Mockito.any(), (Authentication)Mockito.any(), (Service)Mockito.any())).thenReturn(Optional.empty());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param("username", new String[]{"casuser"}).param("password", new String[]{"Mellon"})).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void verifyStatusAuthnFails() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param("username", new String[]{"casuser"}).param("password", new String[]{"Mellon"})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void verifyBadRequest() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param("unknown-param", new String[]{"casuser"})).andExpect(MockMvcResultMatchers.status().is4xxClientError());
    }

    @Test
    public void verifyStatusAuthnException() throws Exception {
        AuthenticationException ex = new AuthenticationException(CollectionUtils.wrap((String)"error", (Object)new FailedLoginException()));
        Mockito.when((Object)this.authenticationSupport.handleInitialAuthenticationTransaction((Service)Mockito.any(), (Credential[])Mockito.any())).thenThrow(new Throwable[]{ex});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)TICKETS_RESOURCE_URL, (Object[])new Object[0]).param("username", new String[]{"casuser"}).param("password", new String[]{"Mellon"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }
}

