/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.query;

import java.io.StringWriter;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketImpl;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSamlAttributeQueryTicketFactory
implements SamlAttributeQueryTicketFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSamlAttributeQueryTicketFactory.class);
    protected final ExpirationPolicy expirationPolicy;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    protected final OpenSamlConfigBean configBean;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SamlAttributeQueryTicket create(String id, SAMLObject samlObject, String relyingParty, TicketGrantingTicket ticketGrantingTicket) {
        try (StringWriter w = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)samlObject);){
            String codeId = this.createTicketIdFor(id);
            Service service = this.webApplicationServiceFactory.createService(relyingParty);
            SamlAttributeQueryTicketImpl at = new SamlAttributeQueryTicketImpl(codeId, service, this.expirationPolicy, relyingParty, w.toString(), ticketGrantingTicket);
            if (ticketGrantingTicket != null) {
                ticketGrantingTicket.getDescendantTickets().add(at.getId());
            }
            SamlAttributeQueryTicketImpl samlAttributeQueryTicketImpl = at;
            return samlAttributeQueryTicketImpl;
        }
    }

    public TicketFactory get(Class<? extends Ticket> clazz) {
        return this;
    }

    @Generated
    public DefaultSamlAttributeQueryTicketFactory(ExpirationPolicy expirationPolicy, ServiceFactory<WebApplicationService> webApplicationServiceFactory, OpenSamlConfigBean configBean) {
        this.expirationPolicy = expirationPolicy;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.configBean = configBean;
    }
}

