/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategyConfigurer;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.saml.services.SamlIdPEntityIdAuthenticationServiceSelectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="samlIdPAuthenticationServiceSelectionStrategyConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlIdPAuthenticationServiceSelectionStrategyConfiguration
implements AuthenticationServiceSelectionStrategyConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPAuthenticationServiceSelectionStrategyConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;

    @ConditionalOnMissingBean(name={"samlIdPEntityIdValidationServiceSelectionStrategy"})
    @Bean
    public AuthenticationServiceSelectionStrategy samlIdPEntityIdValidationServiceSelectionStrategy() {
        return new SamlIdPEntityIdAuthenticationServiceSelectionStrategy(this.webApplicationServiceFactory, this.casProperties.getServer().getPrefix());
    }

    public void configureAuthenticationServiceSelectionStrategy(AuthenticationServiceSelectionPlan plan) {
        plan.registerStrategy(this.samlIdPEntityIdValidationServiceSelectionStrategy());
    }
}

