/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategyConfigurer;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.authentication.SamlIdPServiceFactory;
import org.apereo.cas.support.saml.services.SamlIdPEntityIdAuthenticationServiceSelectionStrategy;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="samlIdPAuthenticationServiceSelectionStrategyConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlIdPAuthenticationServiceSelectionStrategyConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;

    @ConditionalOnMissingBean(name={"samlIdPEntityIdValidationServiceSelectionStrategy"})
    @Bean
    public AuthenticationServiceSelectionStrategy samlIdPEntityIdValidationServiceSelectionStrategy() {
        return new SamlIdPEntityIdAuthenticationServiceSelectionStrategy((ServicesManager)this.servicesManager.getObject(), this.samlIdPServiceFactory(), this.casProperties.getServer().getPrefix());
    }

    @Bean
    public AuthenticationServiceSelectionStrategyConfigurer samlIdPAuthenticationServiceSelectionStrategyConfigurer() {
        return plan -> plan.registerStrategy(this.samlIdPEntityIdValidationServiceSelectionStrategy());
    }

    @Bean
    public ServiceFactory samlIdPServiceFactory() {
        return new SamlIdPServiceFactory();
    }

    @Bean
    public ServiceFactoryConfigurer samlIdPServiceFactoryConfigurer() {
        return () -> CollectionUtils.wrap((Object)this.samlIdPServiceFactory());
    }
}

