/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.consent.ConsentActivationStrategy;
import org.apereo.cas.consent.ConsentableAttributeBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.flow.SamlIdPMetadataUIAction;
import org.apereo.cas.support.saml.web.flow.SamlIdPWebflowConfigurer;
import org.apereo.cas.support.saml.web.idp.profile.builders.attr.SamlIdPAttributeDefinition;
import org.apereo.cas.support.saml.web.idp.web.SamlIdPMultifactorAuthenticationTrigger;
import org.apereo.cas.support.saml.web.idp.web.SamlIdPSingleSignOnParticipationStrategy;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategyConfigurer;
import org.apereo.cas.web.flow.login.SessionStoreTicketGrantingTicketAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.mfa.DefaultMultifactorAuthenticationProviderWebflowEventResolver;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

@Configuration(value="samlIdPWebflowConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlIdPWebflowConfiguration {
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private ObjectProvider<CasDelegatingWebflowEventResolver> initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="casWebflowConfigurationContext")
    private ObjectProvider<CasWebflowEventResolutionConfigurationContext> casWebflowConfigurationContext;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> selectionStrategies;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private ObjectProvider<OpenSamlConfigBean> openSamlConfigBean;
    @Autowired
    @Qualifier(value="samlIdPDistributedSessionStore")
    private ObjectProvider<SessionStore> samlIdPDistributedSessionStore;
    @Autowired
    @Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver")
    private ObjectProvider<SamlRegisteredServiceCachingMetadataResolver> defaultSamlRegisteredServiceCachingMetadataResolver;
    @Autowired
    @Qualifier(value="attributeDefinitionStore")
    private ObjectProvider<AttributeDefinitionStore> attributeDefinitionStore;

    @ConditionalOnMissingBean(name={"samlIdPWebConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer samlIdPWebConfigurer() {
        return new SamlIdPWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.applicationContext, this.casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"samlIdPSessionStoreTicketGrantingTicketAction"})
    public Action samlIdPSessionStoreTicketGrantingTicketAction() {
        return new SessionStoreTicketGrantingTicketAction((SessionStore)this.samlIdPDistributedSessionStore.getObject());
    }

    @ConditionalOnMissingBean(name={"samlIdPMetadataUIParserAction"})
    @Bean
    @RefreshScope
    public Action samlIdPMetadataUIParserAction() {
        return new SamlIdPMetadataUIAction((ServicesManager)this.servicesManager.getObject(), (SamlRegisteredServiceCachingMetadataResolver)this.defaultSamlRegisteredServiceCachingMetadataResolver.getObject(), (AuthenticationServiceSelectionPlan)this.selectionStrategies.getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"samlIdPCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer samlIdPCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.samlIdPWebConfigurer());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"samlIdPSingleSignOnParticipationStrategy"})
    public SingleSignOnParticipationStrategy samlIdPSingleSignOnParticipationStrategy() {
        return new SamlIdPSingleSignOnParticipationStrategy((ServicesManager)this.servicesManager.getObject(), (TicketRegistrySupport)this.ticketRegistrySupport.getObject(), (AuthenticationServiceSelectionPlan)this.selectionStrategies.getObject());
    }

    @Bean
    @ConditionalOnMissingBean(name={"samlIdPSingleSignOnParticipationStrategyConfigurer"})
    @RefreshScope
    public SingleSignOnParticipationStrategyConfigurer samlIdPSingleSignOnParticipationStrategyConfigurer() {
        return chain -> chain.addStrategy(this.samlIdPSingleSignOnParticipationStrategy());
    }

    @Bean
    @ConditionalOnMissingBean(name={"samlIdPMultifactorAuthenticationTrigger"})
    public MultifactorAuthenticationTrigger samlIdPMultifactorAuthenticationTrigger() {
        return new SamlIdPMultifactorAuthenticationTrigger((OpenSamlConfigBean)this.openSamlConfigBean.getObject(), (SessionStore)this.samlIdPDistributedSessionStore.getObject(), (ApplicationContext)this.applicationContext, this.casProperties);
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"samlIdPAuthenticationContextWebflowEventResolver"})
    public CasWebflowEventResolver samlIdPAuthenticationContextWebflowEventResolver() {
        DefaultMultifactorAuthenticationProviderWebflowEventResolver r = new DefaultMultifactorAuthenticationProviderWebflowEventResolver((CasWebflowEventResolutionConfigurationContext)this.casWebflowConfigurationContext.getObject(), this.samlIdPMultifactorAuthenticationTrigger());
        Objects.requireNonNull((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getObject()).addDelegate((CasWebflowEventResolver)r);
        return r;
    }

    @Configuration(value="SamlIdPConsentWebflowConfiguration", proxyBeanMethods=false)
    @ConditionalOnClass(value={ConsentableAttributeBuilder.class})
    public class SamlIdPConsentWebflowConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"samlIdPConsentSingleSignOnParticipationStrategyConfigurer"})
        @RefreshScope
        @Autowired
        public SingleSignOnParticipationStrategyConfigurer samlIdPConsentSingleSignOnParticipationStrategyConfigurer(ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, final ConsentActivationStrategy consentActivationStrategy) {
            return chain -> chain.addStrategy((SingleSignOnParticipationStrategy)new SamlIdPSingleSignOnParticipationStrategy(servicesManager, ticketRegistrySupport, authenticationServiceSelectionPlan){

                public boolean isParticipating(SingleSignOnParticipationRequest ssoRequest) {
                    RequestContext requestContext;
                    Authentication authentication;
                    RegisteredService registeredService;
                    Service service = (Service)ssoRequest.getAttributeValue(Service.class.getName(), Service.class);
                    boolean consentRequired = consentActivationStrategy.isConsentRequired(service, registeredService = (RegisteredService)ssoRequest.getAttributeValue(RegisteredService.class.getName(), RegisteredService.class), authentication = (Authentication)ssoRequest.getAttributeValue(Authentication.class.getName(), Authentication.class), requestContext = RequestContextHolder.getRequestContext());
                    return !consentRequired && super.isParticipating(ssoRequest);
                }
            });
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPConsentableAttributeBuilder"})
        @RefreshScope
        public ConsentableAttributeBuilder samlIdPConsentableAttributeBuilder() {
            return attribute -> {
                Optional result = ((AttributeDefinitionStore)SamlIdPWebflowConfiguration.this.attributeDefinitionStore.getObject()).locateAttributeDefinition(defn -> {
                    if (defn instanceof SamlIdPAttributeDefinition) {
                        SamlIdPAttributeDefinition samlAttr = (SamlIdPAttributeDefinition)SamlIdPAttributeDefinition.class.cast(defn);
                        return samlAttr.getName().equalsIgnoreCase(attribute.getName()) && StringUtils.isNotBlank((CharSequence)samlAttr.getFriendlyName());
                    }
                    return false;
                });
                if (result.isPresent()) {
                    SamlIdPAttributeDefinition samlAttr = (SamlIdPAttributeDefinition)SamlIdPAttributeDefinition.class.cast(result.get());
                    attribute.setFriendlyName(samlAttr.getFriendlyName());
                }
                attribute.getValues().replaceAll(o -> {
                    if (o instanceof XSString) {
                        return ((XSString)o).getValue();
                    }
                    if (o instanceof XSURI) {
                        return ((XSURI)o).getURI();
                    }
                    if (o instanceof Serializable) {
                        return o;
                    }
                    return o.toString();
                });
                return attribute;
            };
        }
    }
}

