/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.mdui.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.mdui.AbstractMetadataResolverAdapter;
import org.apereo.cas.support.saml.mdui.ChainingMetadataResolverAdapter;
import org.apereo.cas.support.saml.mdui.DynamicMetadataResolverAdapter;
import org.apereo.cas.support.saml.mdui.MetadataResolverAdapter;
import org.apereo.cas.support.saml.mdui.StaticMetadataResolverAdapter;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.jooq.lambda.Unchecked;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.filter.impl.RequiredValidUntilFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.SignatureValidationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

@Configuration(value="samlMetadataUIConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlMetadataUIConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlMetadataUIConfiguration.class);
    private static final String DEFAULT_SEPARATOR = "::";
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private OpenSamlConfigBean openSamlConfigBean;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired(required=false)
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired(required=false)
    private FlowBuilderServices flowBuilderServices;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> serviceFactory;
    @Autowired
    private ApplicationContext applicationContext;

    @ConditionalOnMissingBean(name={"chainingSamlMetadataUIMetadataResolverAdapter"})
    @Bean
    public MetadataResolverAdapter chainingSamlMetadataUIMetadataResolverAdapter() {
        return new ChainingMetadataResolverAdapter(CollectionUtils.wrapList((Object[])new MetadataResolverAdapter[]{this.getStaticMetadataResolverAdapter(), this.getDynamicMetadataResolverAdapter()}));
    }

    private MetadataResolverAdapter configureAdapter(AbstractMetadataResolverAdapter adapter) {
        HashMap resources = new HashMap();
        MetadataFilterChain chain = new MetadataFilterChain();
        this.casProperties.getSamlMetadataUi().getResources().forEach(Unchecked.consumer(r -> this.configureResource(resources, chain, (String)r)));
        adapter.setRequireValidMetadata(this.casProperties.getSamlMetadataUi().isRequireValidMetadata());
        adapter.setMetadataResources(resources);
        adapter.setConfigBean(this.openSamlConfigBean);
        return adapter;
    }

    private void configureResource(Map<Resource, MetadataFilterChain> resources, MetadataFilterChain chain, String r) {
        String[] splitArray = StringUtils.commaDelimitedListToStringArray((String)r);
        Arrays.stream(splitArray).forEach(Unchecked.consumer(entry -> {
            String[] arr = entry.split(DEFAULT_SEPARATOR);
            String metadataFile = arr[0];
            String signingKey = arr.length > 1 ? arr[1] : null;
            ArrayList<Object> filters = new ArrayList<Object>();
            if (this.casProperties.getSamlMetadataUi().getMaxValidity() > 0L) {
                filters.add(new RequiredValidUntilFilter(this.casProperties.getSamlMetadataUi().getMaxValidity()));
            }
            boolean addResource = true;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)signingKey)) {
                SignatureValidationFilter sigFilter = SamlUtils.buildSignatureValidationFilter((ResourceLoader)this.resourceLoader, (String)signingKey);
                if (sigFilter != null) {
                    sigFilter.setRequireSignedRoot(this.casProperties.getSamlMetadataUi().isRequireSignedRoot());
                    filters.add(sigFilter);
                } else {
                    LOGGER.warn("Failed to locate the signing key [{}] for [{}]", (Object)signingKey, (Object)metadataFile);
                    addResource = false;
                }
            }
            chain.setFilters(filters);
            Resource resource = this.resourceLoader.getResource(metadataFile);
            if (addResource && ResourceUtils.doesResourceExist((Resource)resource)) {
                resources.put(resource, chain);
            } else {
                LOGGER.warn("Skipping metadata [{}]; Either the resource cannot be retrieved or its signing key is missing", (Object)metadataFile);
            }
        }));
    }

    private MetadataResolverAdapter getDynamicMetadataResolverAdapter() {
        DynamicMetadataResolverAdapter adapter = new DynamicMetadataResolverAdapter();
        this.configureAdapter((AbstractMetadataResolverAdapter)adapter);
        return adapter;
    }

    private MetadataResolverAdapter getStaticMetadataResolverAdapter() {
        StaticMetadataResolverAdapter adapter = new StaticMetadataResolverAdapter();
        this.configureAdapter((AbstractMetadataResolverAdapter)adapter);
        adapter.buildMetadataResolverAggregate();
        return adapter;
    }
}

