/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.mdui.config;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.mdui.MetadataResolverAdapter;
import org.apereo.cas.support.saml.mdui.web.flow.SamlMetadataUIParserAction;
import org.apereo.cas.support.saml.mdui.web.flow.SamlMetadataUIWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="samlMetadataUIWebflowConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlMetadataUIWebflowConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired(required=false)
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired(required=false)
    private FlowBuilderServices flowBuilderServices;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> serviceFactory;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="chainingSamlMetadataUIMetadataResolverAdapter")
    private MetadataResolverAdapter chainingSamlMetadataUIMetadataResolverAdapter;

    @ConditionalOnMissingBean(name={"samlMetadataUIWebConfigurer"})
    @ConditionalOnBean(name={"defaultWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer samlMetadataUIWebConfigurer() {
        SamlMetadataUIWebflowConfigurer w = new SamlMetadataUIWebflowConfigurer(this.flowBuilderServices, this.loginFlowDefinitionRegistry, this.samlMetadataUIParserAction(), this.applicationContext, this.casProperties);
        w.initialize();
        return w;
    }

    @ConditionalOnMissingBean(name={"samlMetadataUIParserAction"})
    @Bean
    public Action samlMetadataUIParserAction() {
        String parameter = (String)StringUtils.defaultIfEmpty((CharSequence)this.casProperties.getSamlMetadataUi().getParameter(), (CharSequence)"entityId");
        return new SamlMetadataUIParserAction(parameter, this.chainingSamlMetadataUIMetadataResolverAdapter, this.serviceFactory, this.servicesManager);
    }
}

