/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.mdui.web.flow;

import java.io.Serializable;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.mdui.MetadataResolverAdapter;
import org.apereo.cas.support.saml.mdui.MetadataUIUtils;
import org.apereo.cas.support.saml.mdui.SamlMetadataUIInfo;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SamlMetadataUIParserAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlMetadataUIParserAction.class);
    private final String entityIdParameterName;
    private final MetadataResolverAdapter metadataAdapter;
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> serviceFactory;

    public SamlMetadataUIParserAction(String entityIdParameterName, MetadataResolverAdapter metadataAdapter, ServiceFactory<WebApplicationService> serviceFactory, ServicesManager servicesManager) {
        this.entityIdParameterName = entityIdParameterName;
        this.metadataAdapter = metadataAdapter;
        this.serviceFactory = serviceFactory;
        this.servicesManager = servicesManager;
    }

    public Event doExecute(RequestContext requestContext) {
        String entityId = this.getEntityIdFromRequest(requestContext);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            LOGGER.debug("No entity id found for parameter [{}]", (Object)this.entityIdParameterName);
            return this.success();
        }
        LOGGER.debug("Located entity id [{}] from request", (Object)entityId);
        if (!MetadataUIUtils.isMetadataFoundForEntityId((MetadataResolverAdapter)this.metadataAdapter, (String)entityId)) {
            LOGGER.debug("Metadata is not found for entity [{}] and CAS service registry is consulted for the entity definition", (Object)entityId);
            RegisteredService registeredService = this.getRegisteredServiceFromRequest(requestContext, entityId);
            LOGGER.debug("Registered service definition linked to [{}] is found as [{}]", (Object)entityId, (Object)registeredService);
            this.verifyRegisteredService(requestContext, registeredService);
            this.loadSamlMetadataIntoRequestContext(requestContext, entityId, registeredService);
        } else {
            LOGGER.debug("Metadata is found for entity [{}]", (Object)entityId);
            RegisteredService registeredService = this.getRegisteredServiceFromRequest(requestContext);
            LOGGER.debug("Registered service definition linked to [{}] is found as [{}]", (Object)entityId, (Object)registeredService);
            this.verifyRegisteredService(requestContext, registeredService);
            this.loadSamlMetadataIntoRequestContext(requestContext, entityId, registeredService);
        }
        return this.success();
    }

    protected void loadSamlMetadataIntoRequestContext(RequestContext requestContext, String entityId, RegisteredService registeredService) {
        LOGGER.debug("Locating SAML MDUI for entity [{}]", (Object)entityId);
        SamlMetadataUIInfo mdui = MetadataUIUtils.locateMetadataUserInterfaceForEntityId((MetadataResolverAdapter)this.metadataAdapter, (String)entityId, (RegisteredService)registeredService, (HttpServletRequest)WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext));
        LOGGER.debug("Located SAML MDUI for entity [{}] as [{}]", (Object)entityId, (Object)mdui);
        WebUtils.putServiceUserInterfaceMetadata((RequestContext)requestContext, (Serializable)mdui);
    }

    protected void verifyRegisteredService(RequestContext requestContext, RegisteredService registeredService) {
        if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.debug("Service [{}] is not recognized/allowed by the CAS service registry", (Object)registeredService);
            if (registeredService != null) {
                WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)requestContext, (URI)registeredService.getAccessStrategy().getUnauthorizedRedirectUrl());
            }
            throw new UnauthorizedServiceException("screen.service.error.message", "");
        }
    }

    protected RegisteredService getRegisteredServiceFromRequest(RequestContext requestContext, String entityId) {
        WebApplicationService currentService = WebUtils.getService((RequestContext)requestContext);
        WebApplicationService service = (WebApplicationService)this.serviceFactory.createService(entityId);
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        if (registeredService == null) {
            LOGGER.debug("Entity id [{}] not found in the registry. Fallback onto [{}]", (Object)entityId, (Object)currentService);
            registeredService = this.servicesManager.findServiceBy((Service)currentService);
        }
        LOGGER.debug("Located service definition [{}]", (Object)registeredService);
        return registeredService;
    }

    protected RegisteredService getRegisteredServiceFromRequest(RequestContext requestContext) {
        WebApplicationService currentService = WebUtils.getService((RequestContext)requestContext);
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)currentService);
        return registeredService;
    }

    protected String getEntityIdFromRequest(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        return request.getParameter(this.entityIdParameterName);
    }
}

