/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml;

import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasDefaultServiceTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.CasRegisteredServicesTestConfiguration;
import org.apereo.cas.config.CasThymeleafConfiguration;
import org.apereo.cas.config.CoreSamlConfiguration;
import org.apereo.cas.config.authentication.support.SamlRestConfiguration;
import org.apereo.cas.config.authentication.support.SamlUniqueTicketIdGeneratorConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.services.web.config.CasThemesConfiguration;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.validation.config.CasCoreValidationConfiguration;
import org.apereo.cas.web.config.CasCookieConfiguration;
import org.apereo.cas.web.config.CasValidationConfiguration;
import org.apereo.cas.web.flow.config.CasCoreWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasMultifactorAuthenticationWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasWebflowContextConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Import;

@SpringBootTest(classes={SharedTestConfiguration.class}, properties={"spring.main.allow-bean-definition-overriding=true"})
public abstract class AbstractOpenSamlTests {
    protected static final String SAML_REQUEST = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><samlp:AuthnRequest xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\" ID=\"5545454455\" Version=\"2.0\" IssueInstant=\"Value\" ProtocolBinding=\"urn:oasis:names.tc:SAML:2.0:bindings:HTTP-Redirect\" ProviderName=\"https://localhost:8443/myRutgers\" AssertionConsumerServiceURL=\"https://localhost:8443/myRutgers\"/>";
    @Autowired
    protected ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    protected OpenSamlConfigBean configBean;
    @Autowired
    @Qualifier(value="shibboleth.ParserPool")
    protected ParserPool parserPool;
    @Autowired
    @Qualifier(value="shibboleth.BuilderFactory")
    protected XMLObjectBuilderFactory builderFactory;
    @Autowired
    @Qualifier(value="shibboleth.MarshallerFactory")
    protected MarshallerFactory marshallerFactory;
    @Autowired
    @Qualifier(value="shibboleth.UnmarshallerFactory")
    protected UnmarshallerFactory unmarshallerFactory;

    @Test
    public void autowireApplicationContext() {
        Assertions.assertNotNull((Object)this.applicationContext);
        Assertions.assertNotNull((Object)this.configBean);
        Assertions.assertNotNull((Object)this.parserPool);
        Assertions.assertNotNull((Object)this.builderFactory);
        Assertions.assertNotNull((Object)this.unmarshallerFactory);
        Assertions.assertNotNull((Object)this.marshallerFactory);
        Assertions.assertNotNull((Object)this.configBean.getParserPool());
    }

    @Test
    public void loadStaticContextFactories() {
        Assertions.assertNotNull((Object)XMLObjectProviderRegistrySupport.getParserPool());
        Assertions.assertNotNull((Object)XMLObjectProviderRegistrySupport.getBuilderFactory());
        Assertions.assertNotNull((Object)XMLObjectProviderRegistrySupport.getMarshallerFactory());
        Assertions.assertNotNull((Object)XMLObjectProviderRegistrySupport.getUnmarshallerFactory());
    }

    @Test
    public void ensureParserIsInitialized() throws Exception {
        Assertions.assertNotNull((Object)this.parserPool);
        Assertions.assertNotNull((Object)this.parserPool.getBuilder());
    }

    @ImportAutoConfiguration(value={RefreshAutoConfiguration.class, MailSenderAutoConfiguration.class, SecurityAutoConfiguration.class, WebMvcAutoConfiguration.class, AopAutoConfiguration.class})
    @SpringBootConfiguration
    @Import(value={CasThymeleafConfiguration.class, CasThemesConfiguration.class, CasRegisteredServicesTestConfiguration.class, CoreSamlConfiguration.class, SamlUniqueTicketIdGeneratorConfiguration.class, SamlRestConfiguration.class, CasCoreWebConfiguration.class, CasCoreWebflowConfiguration.class, CasWebflowContextConfiguration.class, CasPersonDirectoryConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreServicesConfiguration.class, CasCoreValidationConfiguration.class, CasValidationConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreServicesAuthenticationConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasDefaultServiceTicketIdGeneratorsConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreHttpConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreUtilConfiguration.class, CasCookieConfiguration.class, CasCoreMultifactorAuthenticationConfiguration.class, CasMultifactorAuthenticationWebflowConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreConfiguration.class})
    public static class SharedTestConfiguration {
    }
}

