/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml;

import com.google.common.collect.Iterables;
import java.util.UUID;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apereo.cas.support.saml.AbstractOpenSamlTests;
import org.apereo.cas.support.saml.InMemoryResourceMetadataResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@SpringBootTest(classes={AbstractOpenSamlTests.SharedTestConfiguration.class}, properties={"spring.main.allow-bean-definition-overriding=true"})
@Tag(value="SAMLMetadata")
public class InMemoryResourceMetadataResolverTests
extends AbstractOpenSamlTests {
    @Test
    public void verifyValidMetadataResource() throws Exception {
        InMemoryResourceMetadataResolver resolver = new InMemoryResourceMetadataResolver((Resource)new ClassPathResource("metadata/metadata-valid.xml"), this.configBean);
        resolver.setId(UUID.randomUUID().toString());
        resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EntityIdCriterion("urn:app.e2ma.net"));
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        Iterable resolved = resolver.resolve(criteriaSet);
        Assertions.assertFalse((boolean)Iterables.isEmpty((Iterable)resolved));
    }

    @Test
    public void verifyExpiredValidUntilMetadataResource() throws Exception {
        InMemoryResourceMetadataResolver resolver = new InMemoryResourceMetadataResolver((Resource)new ClassPathResource("metadata/metadata-expired.xml"), this.configBean);
        resolver.setId(UUID.randomUUID().toString());
        resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EntityIdCriterion("urn:app.e2ma.net"));
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        Iterable resolved = resolver.resolve(criteriaSet);
        Assertions.assertTrue((boolean)Iterables.isEmpty((Iterable)resolved));
    }

    @Test
    public void verifyInvalidExpiredMetadataResourceIsOkay() throws Exception {
        InMemoryResourceMetadataResolver resolver = new InMemoryResourceMetadataResolver((Resource)new ClassPathResource("metadata/metadata-expired.xml"), this.configBean);
        resolver.setRequireValidMetadata(false);
        resolver.setId(UUID.randomUUID().toString());
        resolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EntityIdCriterion("urn:app.e2ma.net"));
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        Iterable resolved = resolver.resolve(criteriaSet);
        Assertions.assertFalse((boolean)Iterables.isEmpty((Iterable)resolved));
    }
}

