/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.authentication;

import java.util.HashMap;
import java.util.List;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationTransactionFactory;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.support.saml.authentication.SamlAuthenticationMetaDataPopulator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="SAML")
public class SamlAuthenticationMetaDataPopulatorTests {
    private SamlAuthenticationMetaDataPopulator populator;

    @BeforeEach
    public void initialize() {
        this.populator = new SamlAuthenticationMetaDataPopulator();
    }

    @Test
    public void verifyAuthenticationTypeFound() {
        UsernamePasswordCredential credentials = new UsernamePasswordCredential();
        AuthenticationBuilder builder = CoreAuthenticationTestUtils.getAuthenticationBuilder();
        this.populator.populateAttributes(builder, new DefaultAuthenticationTransactionFactory().newTransaction(new Credential[]{credentials}));
        Authentication auth = builder.build();
        Assertions.assertEquals((Object)"urn:oasis:names:tc:SAML:1.0:am:password", ((List)auth.getAttributes().get("samlAuthenticationStatementAuthMethod")).get(0));
    }

    @Test
    public void verifyAuthenticationTypeFoundByDefault() {
        CustomCredential credentials = new CustomCredential();
        AuthenticationBuilder builder = CoreAuthenticationTestUtils.getAuthenticationBuilder();
        this.populator.populateAttributes(builder, new DefaultAuthenticationTransactionFactory().newTransaction(new Credential[]{credentials}));
        Authentication auth = builder.build();
        Assertions.assertNotNull(((List)auth.getAttributes().get("samlAuthenticationStatementAuthMethod")).get(0));
    }

    @Test
    public void verifyAuthenticationTypeFoundCustom() {
        CustomCredential credentials = new CustomCredential();
        HashMap<String, String> added = new HashMap<String, String>();
        added.put(CustomCredential.class.getName(), "FF");
        this.populator.setUserDefinedMappings(added);
        AuthenticationBuilder builder = CoreAuthenticationTestUtils.getAuthenticationBuilder();
        this.populator.populateAttributes(builder, new DefaultAuthenticationTransactionFactory().newTransaction(new Credential[]{credentials}));
        Authentication auth = builder.build();
        Assertions.assertEquals((Object)"FF", ((List)auth.getAttributes().get("samlAuthenticationStatementAuthMethod")).get(0));
    }

    private static class CustomCredential
    implements Credential {
        private static final long serialVersionUID = 8040541789035593268L;

        private CustomCredential() {
        }

        public String getId() {
            return "nobody";
        }
    }
}

