/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.authentication.principal;

import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.NotImplementedException;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.config.SamlConfiguration;
import org.apereo.cas.config.authentication.support.SamlAuthenticationEventExecutionPlanConfiguration;
import org.apereo.cas.config.authentication.support.SamlServiceFactoryConfiguration;
import org.apereo.cas.support.saml.AbstractOpenSamlTests;
import org.apereo.cas.support.saml.authentication.principal.SamlService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;

@SpringBootTest(classes={SamlAuthenticationEventExecutionPlanConfiguration.class, SamlServiceFactoryConfiguration.class, SamlConfiguration.class, AbstractOpenSamlTests.SharedTestConfiguration.class}, properties={"spring.main.allow-bean-definition-overriding=true"})
@Tag(value="SAML")
public class SamlServiceFactoryTests
extends AbstractOpenSamlTests {
    private static final String BODY = "<!--    Licensed to Jasig under one or more contributor license    agreements. See the NOTICE file distributed with this workfor additional information regarding copyright ownership.    Jasig licenses this file to you under the Apache License,    Version 2.0 (the \"License\"); you may not use this file    except in compliance with the License.  You may obtain a    copy of the License at the following location:      http://www.apache.org/licenses/LICENSE-2.0    Unless required by applicable law or agreed to in writing,software distributed under the License is distributed on an    \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY    KIND, either express or implied.See the License for the    specific language governing permissions and limitations    under the License.--><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns=\"urn:oasis:names:tc:SAML:1.0:protocol\">    <soap:Header/>   <soap:Body>        <Request MajorVersion=\"1\" MinorVersion=\"1\" RequestID=\"_e444ee1af9a7f6d656d76e8810299544\" IssueInstant=\"2018-05-10T16:39:46Z\"><AssertionArtifact>ST-AAHJJ4pD5ZyoQkY9i08GsvYRVOyKeWws4SA4xwv+5HX9UgL7fCRBp2Ad</AssertionArtifact>        </Request>    </soap:Body></soap:Envelope>";
    @Autowired
    @Qualifier(value="samlServiceFactory")
    private ServiceFactory<SamlService> samlServiceFactory;

    @Test
    public void verifyObtainService() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod(HttpMethod.POST.name());
        request.setParameter("TARGET", "test");
        SamlService service = (SamlService)this.samlServiceFactory.createService((HttpServletRequest)request);
        Assertions.assertEquals((Object)"test", (Object)service.getId());
    }

    @Test
    public void verifyServiceDoesNotExist() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod(HttpMethod.POST.name());
        Assertions.assertNull((Object)this.samlServiceFactory.createService((HttpServletRequest)request));
    }

    @Test
    public void verifyPayloadCanBeParsedProperly() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod(HttpMethod.POST.name());
        request.setParameter("TARGET", "test");
        request.setContent(BODY.getBytes(StandardCharsets.UTF_8));
        request.setRequestURI("/samlValidate");
        Assertions.assertNotNull((Object)this.samlServiceFactory.createService((HttpServletRequest)request));
    }

    @Test
    public void verifyPayloadAsAttr() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod(HttpMethod.POST.name());
        request.setParameter("TARGET", "test");
        request.setAttribute("SAMLRequest", (Object)BODY);
        request.setRequestURI("/samlValidate");
        Assertions.assertNotNull((Object)this.samlServiceFactory.createService((HttpServletRequest)request));
        Assertions.assertThrows(NotImplementedException.class, () -> this.samlServiceFactory.createService("serviceid"));
    }

    @Test
    public void verifyEmptyBody() {
        String body = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns=\"urn:oasis:names:tc:SAML:1.0:protocol\"><soap:Header/></soap:Envelope>";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod(HttpMethod.POST.name());
        request.setParameter("TARGET", "test");
        request.setAttribute("SAMLRequest", (Object)"<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns=\"urn:oasis:names:tc:SAML:1.0:protocol\"><soap:Header/></soap:Envelope>");
        request.setRequestURI("/samlValidate");
        SamlService service = (SamlService)this.samlServiceFactory.createService((HttpServletRequest)request);
        Assertions.assertNull((Object)service.getArtifactId());
        Assertions.assertNull((Object)service.getRequestId());
    }

    @Test
    public void verifyNoReqIdBody() {
        String body = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns=\"urn:oasis:names:tc:SAML:1.0:protocol\"><soap:Header/><soap:Body><Request MajorVersion=\"1\" MinorVersion=\"1\" IssueInstant=\"2018-05-10T16:39:46Z\"><AssertionArtifact>ST-AAHJJ4pD5ZyoQkY9i08GsvYRVOyKeWws4SA4xwv+5HX9UgL7fCRBp2Ad</AssertionArtifact></Request></soap:Body></soap:Envelope>";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod(HttpMethod.POST.name());
        request.setParameter("TARGET", "test");
        request.setAttribute("SAMLRequest", (Object)"<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns=\"urn:oasis:names:tc:SAML:1.0:protocol\"><soap:Header/><soap:Body><Request MajorVersion=\"1\" MinorVersion=\"1\" IssueInstant=\"2018-05-10T16:39:46Z\"><AssertionArtifact>ST-AAHJJ4pD5ZyoQkY9i08GsvYRVOyKeWws4SA4xwv+5HX9UgL7fCRBp2Ad</AssertionArtifact></Request></soap:Body></soap:Envelope>");
        request.setRequestURI("/samlValidate");
        SamlService service = (SamlService)this.samlServiceFactory.createService((HttpServletRequest)request);
        Assertions.assertNotNull((Object)service.getArtifactId());
        Assertions.assertNull((Object)service.getRequestId());
    }

    @Test
    public void verifyArtifactInBody() {
        String body = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns=\"urn:oasis:names:tc:SAML:1.0:protocol\"><soap:Header/><soap:Body><Request MajorVersion=\"1\" MinorVersion=\"1\" IssueInstant=\"2018-05-10T16:39:46Z\"></Request></soap:Body></soap:Envelope>";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod(HttpMethod.POST.name());
        request.setParameter("TARGET", "test");
        request.setAttribute("SAMLRequest", (Object)"<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns=\"urn:oasis:names:tc:SAML:1.0:protocol\"><soap:Header/><soap:Body><Request MajorVersion=\"1\" MinorVersion=\"1\" IssueInstant=\"2018-05-10T16:39:46Z\"></Request></soap:Body></soap:Envelope>");
        request.setRequestURI("/samlValidate");
        SamlService service = (SamlService)this.samlServiceFactory.createService((HttpServletRequest)request);
        Assertions.assertNull((Object)service.getArtifactId());
    }

    @Test
    public void verifyBadBody() {
        String body = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns=\"urn:oasis:names:tc:SAML:1.0:protocol\"><soap:Header/><soap:Body></Request></soap:Envelope>";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod(HttpMethod.POST.name());
        request.setParameter("TARGET", "test");
        request.setAttribute("SAMLRequest", (Object)"<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns=\"urn:oasis:names:tc:SAML:1.0:protocol\"><soap:Header/><soap:Body></Request></soap:Envelope>");
        request.setRequestURI("/samlValidate");
        SamlService service = (SamlService)this.samlServiceFactory.createService((HttpServletRequest)request);
        Assertions.assertNull((Object)service.getArtifactId());
        Assertions.assertNull((Object)service.getArtifactId());
    }
}

