/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.authentication.principal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.DefaultServiceMatchingStrategy;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.config.SamlConfiguration;
import org.apereo.cas.config.authentication.support.SamlAuthenticationEventExecutionPlanConfiguration;
import org.apereo.cas.config.authentication.support.SamlServiceFactoryConfiguration;
import org.apereo.cas.services.DefaultServicesManager;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.support.saml.AbstractOpenSamlTests;
import org.apereo.cas.support.saml.authentication.principal.SamlService;
import org.apereo.cas.support.saml.authentication.principal.SamlServiceResponseBuilder;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.support.DefaultArgumentExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;

@Import(value={SamlAuthenticationEventExecutionPlanConfiguration.class, SamlServiceFactoryConfiguration.class, SamlConfiguration.class})
@Tag(value="SAML")
public class SamlServiceTests
extends AbstractOpenSamlTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "samlService.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    @Autowired
    @Qualifier(value="urlValidator")
    private UrlValidator urlValidator;
    @Autowired
    @Qualifier(value="samlServiceFactory")
    private ServiceFactory<SamlService> samlServiceFactory;

    @Test
    public void verifyResponse() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("TARGET", "service");
        SamlService impl = (SamlService)this.samlServiceFactory.createService((HttpServletRequest)request);
        ServicesManagerConfigurationContext context = ServicesManagerConfigurationContext.builder().serviceRegistry((ServiceRegistry)Mockito.mock(ServiceRegistry.class)).applicationContext(this.applicationContext).environments(new HashSet(0)).servicesCache(Caffeine.newBuilder().build()).registeredServiceLocators(List.of(new DefaultServicesManagerRegisteredServiceLocator())).build();
        Response response = new SamlServiceResponseBuilder((ServicesManager)new DefaultServicesManager(context), this.urlValidator).build((WebApplicationService)impl, "ticketId", CoreAuthenticationTestUtils.getAuthentication());
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)Response.ResponseType.REDIRECT, (Object)response.getResponseType());
        Assertions.assertTrue((boolean)response.getUrl().contains("SAMLart".concat("=")));
    }

    @Test
    public void verifyResponseForJsession() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("TARGET", "http://www.cnn.com/;jsession=test");
        SamlService impl = (SamlService)this.samlServiceFactory.createService((HttpServletRequest)request);
        Assertions.assertEquals((Object)"http://www.cnn.com/", (Object)impl.getId());
    }

    @Test
    public void verifyResponseWithNoTicket() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("TARGET", "service");
        SamlService impl = (SamlService)this.samlServiceFactory.createService((HttpServletRequest)request);
        ServicesManagerConfigurationContext context = ServicesManagerConfigurationContext.builder().serviceRegistry((ServiceRegistry)Mockito.mock(ServiceRegistry.class)).applicationContext(this.applicationContext).environments(new HashSet(0)).servicesCache(Caffeine.newBuilder().build()).registeredServiceLocators(List.of(new DefaultServicesManagerRegisteredServiceLocator())).build();
        Response response = new SamlServiceResponseBuilder((ServicesManager)new DefaultServicesManager(context), this.urlValidator).build((WebApplicationService)impl, null, CoreAuthenticationTestUtils.getAuthentication());
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)Response.ResponseType.REDIRECT, (Object)response.getResponseType());
        Assertions.assertFalse((boolean)response.getUrl().contains("SAMLart".concat("=")));
    }

    @Test
    public void verifyRequestBody() {
        String body = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body><samlp:Request xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\" MajorVersion=\"1\" MinorVersion=\"1\" RequestID=\"_192.168.16.51.1024506224022\" IssueInstant=\"2002-06-19T17:03:44.022Z\"><samlp:AssertionArtifact> \n\n   artifact    \n\n   </samlp:AssertionArtifact></samlp:Request></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/samlValidate");
        request.setMethod("POST");
        request.setContent("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body><samlp:Request xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\" MajorVersion=\"1\" MinorVersion=\"1\" RequestID=\"_192.168.16.51.1024506224022\" IssueInstant=\"2002-06-19T17:03:44.022Z\"><samlp:AssertionArtifact> \n\n   artifact    \n\n   </samlp:AssertionArtifact></samlp:Request></SOAP-ENV:Body></SOAP-ENV:Envelope>".getBytes(StandardCharsets.UTF_8));
        SamlService impl = (SamlService)this.samlServiceFactory.createService((HttpServletRequest)request);
        Assertions.assertEquals((Object)"artifact", (Object)impl.getArtifactId());
        Assertions.assertEquals((Object)"_192.168.16.51.1024506224022", (Object)impl.getRequestId());
    }

    @Test
    public void verifyTargetMatchingSamlService() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("TARGET", "https://some.service.edu/path/to/app");
        WebApplicationService service = new DefaultArgumentExtractor(this.samlServiceFactory).extractService((HttpServletRequest)request);
        WebApplicationService impl = new DefaultArgumentExtractor(this.samlServiceFactory).extractService((HttpServletRequest)request);
        ServicesManager manager = (ServicesManager)Mockito.mock(ServicesManager.class);
        Assertions.assertTrue((boolean)new DefaultServiceMatchingStrategy(manager).matches((Service)impl, (Service)service));
    }

    @Test
    public void verifyTargetMatchesNoSamlService() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("TARGET", "https://some.service.edu/path/to/app");
        WebApplicationService impl = new DefaultArgumentExtractor(this.samlServiceFactory).extractService((HttpServletRequest)request);
        MockHttpServletRequest request2 = new MockHttpServletRequest();
        request2.setParameter("TARGET", "https://some.SERVICE.edu");
        WebApplicationService service = new DefaultArgumentExtractor(this.samlServiceFactory).extractService((HttpServletRequest)request2);
        ServicesManager manager = (ServicesManager)Mockito.mock(ServicesManager.class);
        Assertions.assertFalse((boolean)new DefaultServiceMatchingStrategy(manager).matches((Service)impl, (Service)service));
    }

    @Test
    public void verifySerializeASamlServiceToJson() throws IOException {
        String body = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body><samlp:Request xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\" MajorVersion=\"1\" MinorVersion=\"1\" RequestID=\"_192.168.16.51.1024506224022\" IssueInstant=\"2002-06-19T17:03:44.022Z\"><samlp:AssertionArtifact>artifact</samlp:AssertionArtifact></samlp:Request></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContent("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body><samlp:Request xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\" MajorVersion=\"1\" MinorVersion=\"1\" RequestID=\"_192.168.16.51.1024506224022\" IssueInstant=\"2002-06-19T17:03:44.022Z\"><samlp:AssertionArtifact>artifact</samlp:AssertionArtifact></samlp:Request></SOAP-ENV:Body></SOAP-ENV:Envelope>".getBytes(StandardCharsets.UTF_8));
        SamlService serviceWritten = (SamlService)this.samlServiceFactory.createService((HttpServletRequest)request);
        MAPPER.writeValue(JSON_FILE, (Object)serviceWritten);
        SamlService serviceRead = (SamlService)MAPPER.readValue(JSON_FILE, SamlService.class);
        Assertions.assertEquals((Object)serviceWritten, (Object)serviceRead);
    }
}

