/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web;

import java.util.Map;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.CasThymeleafConfiguration;
import org.apereo.cas.config.CoreSamlConfiguration;
import org.apereo.cas.config.SamlConfiguration;
import org.apereo.cas.config.authentication.support.SamlAuthenticationEventExecutionPlanConfiguration;
import org.apereo.cas.config.authentication.support.SamlServiceFactoryConfiguration;
import org.apereo.cas.config.authentication.support.SamlUniqueTicketIdGeneratorConfiguration;
import org.apereo.cas.services.web.config.CasThemesConfiguration;
import org.apereo.cas.support.saml.web.SamlValidateEndpoint;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.web.config.CasValidationConfiguration;
import org.apereo.cas.web.report.AbstractCasEndpointTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest(classes={AbstractCasEndpointTests.SharedTestConfiguration.class, CoreSamlConfiguration.class, CasValidationConfiguration.class, CasPersonDirectoryConfiguration.class, SamlServiceFactoryConfiguration.class, SamlUniqueTicketIdGeneratorConfiguration.class, SamlAuthenticationEventExecutionPlanConfiguration.class, CasThemesConfiguration.class, CasThymeleafConfiguration.class, SamlConfiguration.class}, properties={"management.endpoints.web.exposure.include=*", "management.endpoint.samlValidate.enabled=true"})
@Tag(value="SAML")
public class SamlValidateEndpointTests
extends AbstractCasEndpointTests {
    @Autowired
    @Qualifier(value="samlValidateEndpoint")
    private SamlValidateEndpoint samlValidateEndpoint;
    @Autowired
    @Qualifier(value="samlProtocolEndpointConfigurer")
    private ProtocolEndpointWebSecurityConfigurer<Void> samlProtocolEndpointConfigurer;

    @Test
    public void verifyEndpoints() {
        Assertions.assertFalse((boolean)this.samlProtocolEndpointConfigurer.getIgnoredEndpoints().isEmpty());
    }

    @Test
    public void verifyOperation() {
        Service service = CoreAuthenticationTestUtils.getService();
        Assertions.assertNotNull((Object)this.samlValidateEndpoint);
        Map results = this.samlValidateEndpoint.handle("sample", "sample", service.getId());
        Assertions.assertNotNull((Object)results);
        Assertions.assertFalse((boolean)results.isEmpty());
    }
}

